<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProducto.xml */
/* Generado: 2024-08-07 03:13:10 */

/* Mantenimiento de los registros de la tabla MST_ReferenciaProducto */
abstract class BaseMST_ReferenciaProductoDP extends MST_ReferenciaProductoBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ReferenciaProductoBN ) */
    public function __construct( MST_ReferenciaProductoBN $o_MST_ReferenciaProductoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ReferenciaProductoBN ) )
        {
            $this->setByBN( $o_MST_ReferenciaProductoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ReferenciaProductoBN */
    public function setByBN( MST_ReferenciaProductoBN $o_MST_ReferenciaProductoBN )
    {
        if ( !is_null( $o_MST_ReferenciaProductoBN->getIdReferencia() ) )
        {
            $this->setIdReferencia( $o_MST_ReferenciaProductoBN->getIdReferencia() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_ReferenciaProductoBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ReferenciaProductoBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ReferenciaProductoBN->getEstado() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getCantTrx() ) )
        {
            $this->setCantTrx( $o_MST_ReferenciaProductoBN->getCantTrx() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ReferenciaProductoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ReferenciaProductoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ReferenciaProductoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ReferenciaProductoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ReferenciaProductoBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
        $o_MST_ReferenciaProductoBN = $o_MST_ReferenciaProductoFN->selectByPk( $this->getIdReferencia() );
        if ( is_null( $o_MST_ReferenciaProductoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ReferenciaProducto ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdReferencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdReferencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdReferencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProveedor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdProveedor";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdProveedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantTrx() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CantTrx";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantTrx()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ReferenciaProducto SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdProveedor() ) )
            {
                $s_SQLQuery .= $s_Separator."IdProveedor = ".$this->getIdProveedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantTrx() ) )
            {
                $s_SQLQuery .= $s_Separator."CantTrx = ".$this->getCantTrx()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdReferencia = ".$this->getIdReferencia().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ReferenciaProducto WHERE  IdReferencia = ".$this->getIdReferencia().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>