<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_RangoDetalle.xml */
/* Generado: 2021-02-20 22:06:18 */

/* Mantenimiento de los registros de la tabla MST_RangoDetalle */
abstract class BaseMST_RangoDetalleDP extends MST_RangoDetalleBV
{
    /* Constructor ( Establece los valores desde un objeto MST_RangoDetalleBN ) */
    public function __construct( MST_RangoDetalleBN $o_MST_RangoDetalleBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_RangoDetalleBN ) )
        {
            $this->setByBN( $o_MST_RangoDetalleBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_RangoDetalleBN */
    public function setByBN( MST_RangoDetalleBN $o_MST_RangoDetalleBN )
    {
        if ( !is_null( $o_MST_RangoDetalleBN->getIdRangoDetalle() ) )
        {
            $this->setIdRangoDetalle( $o_MST_RangoDetalleBN->getIdRangoDetalle() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getIdRango() ) )
        {
            $this->setIdRango( $o_MST_RangoDetalleBN->getIdRango() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getMinimo() ) )
        {
            $this->setMinimo( $o_MST_RangoDetalleBN->getMinimo() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getMaximo() ) )
        {
            $this->setMaximo( $o_MST_RangoDetalleBN->getMaximo() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_RangoDetalleBN->getEstado() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_RangoDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_RangoDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_RangoDetalleBN->getFechaModificacion() );
        }
        if ( !is_null( $o_MST_RangoDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_RangoDetalleBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_RangoDetalleFN = new MST_RangoDetalleFN();
        $o_MST_RangoDetalleBN = $o_MST_RangoDetalleFN->selectByPk( $this->getIdRangoDetalle() );
        if ( is_null( $o_MST_RangoDetalleBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_RangoDetalle ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdRangoDetalle() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRangoDetalle";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdRangoDetalle()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdRango() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRango";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdRango()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMinimo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Minimo";
                $s_SQLQuery2 .= $s_Separator."".$this->getMinimo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMaximo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Maximo";
                $s_SQLQuery2 .= $s_Separator."".$this->getMaximo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_RangoDetalle SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdRango() ) )
            {
                $s_SQLQuery .= $s_Separator."IdRango = ".$this->getIdRango()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMinimo() ) )
            {
                $s_SQLQuery .= $s_Separator."Minimo = ".$this->getMinimo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMaximo() ) )
            {
                $s_SQLQuery .= $s_Separator."Maximo = ".$this->getMaximo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdRangoDetalle = ".$this->getIdRangoDetalle().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_RangoDetalle WHERE  IdRangoDetalle = ".$this->getIdRangoDetalle().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>