<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Pais.xml */
/* Generado: 2021-08-07 04:50:36 */

/* Mantenimiento de los registros de la tabla MST_Pais */
abstract class BaseMST_PaisDP extends MST_PaisBV
{
    /* Constructor ( Establece los valores desde un objeto MST_PaisBN ) */
    public function __construct( MST_PaisBN $o_MST_PaisBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_PaisBN ) )
        {
            $this->setByBN( $o_MST_PaisBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_PaisBN */
    public function setByBN( MST_PaisBN $o_MST_PaisBN )
    {
        if ( !is_null( $o_MST_PaisBN->getId() ) )
        {
            $this->setId( $o_MST_PaisBN->getId() );
        }
        if ( !is_null( $o_MST_PaisBN->getNombre() ) )
        {
            $this->setNombre( $o_MST_PaisBN->getNombre() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_PaisFN = new MST_PaisFN();
        $o_MST_PaisBN = $o_MST_PaisFN->selectByPk( $this->getId() );
        if ( is_null( $o_MST_PaisBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_Pais ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Id";
                $s_SQLQuery2 .= $s_Separator."'".$this->getId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_Pais SET ";
            $s_Separator = "";
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  Id = '".$this->getId()."';";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_Pais WHERE  Id = '".$this->getId()."';";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>