<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_DiasAlq.xml */
/* Generado: 2021-09-07 05:02:24 */

/* Mantenimiento de los registros de la tabla MST_DiasAlq */
abstract class BaseMST_DiasAlqDP extends MST_DiasAlqBV
{
    /* Constructor ( Establece los valores desde un objeto MST_DiasAlqBN ) */
    public function __construct( MST_DiasAlqBN $o_MST_DiasAlqBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_DiasAlqBN ) )
        {
            $this->setByBN( $o_MST_DiasAlqBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_DiasAlqBN */
    public function setByBN( MST_DiasAlqBN $o_MST_DiasAlqBN )
    {
        if ( !is_null( $o_MST_DiasAlqBN->getDiasAlqId() ) )
        {
            $this->setDiasAlqId( $o_MST_DiasAlqBN->getDiasAlqId() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_DiasAlqBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getCantDias() ) )
        {
            $this->setCantDias( $o_MST_DiasAlqBN->getCantDias() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_DiasAlqBN->getEstado() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_DiasAlqBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_DiasAlqBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_DiasAlqBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_DiasAlqBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_DiasAlqBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_DiasAlqFN = new MST_DiasAlqFN();
        $o_MST_DiasAlqBN = $o_MST_DiasAlqFN->selectByPk( $this->getDiasAlqId() );
        if ( is_null( $o_MST_DiasAlqBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_DiasAlq ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getDiasAlqId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DiasAlqId";
                $s_SQLQuery2 .= $s_Separator."".$this->getDiasAlqId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantDias() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CantDias";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantDias()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_DiasAlq SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantDias() ) )
            {
                $s_SQLQuery .= $s_Separator."CantDias = ".$this->getCantDias()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  DiasAlqId = ".$this->getDiasAlqId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_DiasAlq WHERE  DiasAlqId = ".$this->getDiasAlqId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>