<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ClaseLinea.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Mantenimiento de los registros de la tabla MST_ClaseLinea */
abstract class BaseMST_ClaseLineaDP extends MST_ClaseLineaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_ClaseLineaBN ) */
    public function __construct( MST_ClaseLineaBN $o_MST_ClaseLineaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_ClaseLineaBN ) )
        {
            $this->setByBN( $o_MST_ClaseLineaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_ClaseLineaBN */
    public function setByBN( MST_ClaseLineaBN $o_MST_ClaseLineaBN )
    {
        if ( !is_null( $o_MST_ClaseLineaBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_MST_ClaseLineaBN->getIdLinea() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_ClaseLineaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getCodigo() ) )
        {
            $this->setCodigo( $o_MST_ClaseLineaBN->getCodigo() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_ClaseLineaBN->getEstado() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_ClaseLineaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_ClaseLineaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_ClaseLineaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_ClaseLineaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_ClaseLineaBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaBN = $o_MST_ClaseLineaFN->selectByPk( $this->getIdLinea() );
        if ( is_null( $o_MST_ClaseLineaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_ClaseLinea ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdLinea() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdLinea";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdLinea()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Codigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_ClaseLinea SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."Codigo = '".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdLinea = ".$this->getIdLinea().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_ClaseLinea WHERE  IdLinea = ".$this->getIdLinea().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>