<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_CategoriaTalla.xml */
/* Generado: 2024-07-07 08:03:42 */

/* Mantenimiento de los registros de la tabla MST_CategoriaTalla */
abstract class BaseMST_CategoriaTallaDP extends MST_CategoriaTallaBV
{
    /* Constructor ( Establece los valores desde un objeto MST_CategoriaTallaBN ) */
    public function __construct( MST_CategoriaTallaBN $o_MST_CategoriaTallaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_MST_CategoriaTallaBN ) )
        {
            $this->setByBN( $o_MST_CategoriaTallaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto MST_CategoriaTallaBN */
    public function setByBN( MST_CategoriaTallaBN $o_MST_CategoriaTallaBN )
    {
        if ( !is_null( $o_MST_CategoriaTallaBN->getIdCatTalla() ) )
        {
            $this->setIdCatTalla( $o_MST_CategoriaTallaBN->getIdCatTalla() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getIdProveedor() ) )
        {
            $this->setIdProveedor( $o_MST_CategoriaTallaBN->getIdProveedor() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_MST_CategoriaTallaBN->getDescripcion() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getEstado() ) )
        {
            $this->setEstado( $o_MST_CategoriaTallaBN->getEstado() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_MST_CategoriaTallaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_MST_CategoriaTallaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_MST_CategoriaTallaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_MST_CategoriaTallaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_MST_CategoriaTallaBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        $o_MST_CategoriaTallaBN = $o_MST_CategoriaTallaFN->selectByPk( $this->getIdCatTalla() );
        if ( is_null( $o_MST_CategoriaTallaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO MST_CategoriaTalla ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCatTalla() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCatTalla";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCatTalla()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProveedor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdProveedor";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdProveedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE MST_CategoriaTalla SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdProveedor() ) )
            {
                $s_SQLQuery .= $s_Separator."IdProveedor = ".$this->getIdProveedor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCatTalla = ".$this->getIdCatTalla().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM MST_CategoriaTalla WHERE  IdCatTalla = ".$this->getIdCatTalla().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>