<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_TipoCambio.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla GSS_TipoCambio */
abstract class BaseGSS_TipoCambioDP extends GSS_TipoCambioBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_TipoCambioBN ) */
    public function __construct( GSS_TipoCambioBN $o_GSS_TipoCambioBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_TipoCambioBN ) )
        {
            $this->setByBN( $o_GSS_TipoCambioBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_TipoCambioBN */
    public function setByBN( GSS_TipoCambioBN $o_GSS_TipoCambioBN )
    {
        if ( !is_null( $o_GSS_TipoCambioBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_GSS_TipoCambioBN->getIdMoneda() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getIdMonedaCambio() ) )
        {
            $this->setIdMonedaCambio( $o_GSS_TipoCambioBN->getIdMonedaCambio() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getIdFechaCambio() ) )
        {
            $this->setIdFechaCambio( $o_GSS_TipoCambioBN->getIdFechaCambio() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_TipoCambioBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getSunatCompra() ) )
        {
            $this->setSunatCompra( $o_GSS_TipoCambioBN->getSunatCompra() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getSunatVenta() ) )
        {
            $this->setSunatVenta( $o_GSS_TipoCambioBN->getSunatVenta() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getTipoCambioCobranza() ) )
        {
            $this->setTipoCambioCobranza( $o_GSS_TipoCambioBN->getTipoCambioCobranza() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_TipoCambioBN->getEstado() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_TipoCambioBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_TipoCambioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_TipoCambioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_TipoCambioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_TipoCambioBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_TipoCambioFN = new GSS_TipoCambioFN();
        $o_GSS_TipoCambioBN = $o_GSS_TipoCambioFN->selectByPk( $this->getIdMoneda(), $this->getIdMonedaCambio(), $this->getIdFechaCambio(), $this->getIdCompania() );
        if ( is_null( $o_GSS_TipoCambioBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_TipoCambio ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdMoneda() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdMoneda";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdMoneda()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdMonedaCambio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdMonedaCambio";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdMonedaCambio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFechaCambio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdFechaCambio";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdFechaCambio()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatCompra() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SunatCompra";
                $s_SQLQuery2 .= $s_Separator."".$this->getSunatCompra()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SunatVenta";
                $s_SQLQuery2 .= $s_Separator."".$this->getSunatVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoCambioCobranza() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoCambioCobranza";
                $s_SQLQuery2 .= $s_Separator."".$this->getTipoCambioCobranza()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_TipoCambio SET ";
            $s_Separator = "";
            if ( !is_null( $this->getSunatCompra() ) )
            {
                $s_SQLQuery .= $s_Separator."SunatCompra = ".$this->getSunatCompra()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSunatVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."SunatVenta = ".$this->getSunatVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoCambioCobranza() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoCambioCobranza = ".$this->getTipoCambioCobranza()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdMoneda = '".$this->getIdMoneda()."' AND  IdMonedaCambio = '".$this->getIdMonedaCambio()."' AND  IdFechaCambio = '".$this->getIdFechaCambio()."' AND  IdCompania = ".$this->getIdCompania().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_TipoCambio WHERE  IdMoneda = '".$this->getIdMoneda()."' AND  IdMonedaCambio = '".$this->getIdMonedaCambio()."' AND  IdFechaCambio = '".$this->getIdFechaCambio()."' AND  IdCompania = ".$this->getIdCompania().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>