<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Sucursal.xml */
/* Generado: 2022-01-18 15:31:54 */

/* Mantenimiento de los registros de la tabla GSS_Sucursal */
abstract class BaseGSS_SucursalDP extends GSS_SucursalBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_SucursalBN ) */
    public function __construct( GSS_SucursalBN $o_GSS_SucursalBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_SucursalBN ) )
        {
            $this->setByBN( $o_GSS_SucursalBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_SucursalBN */
    public function setByBN( GSS_SucursalBN $o_GSS_SucursalBN )
    {
        if ( !is_null( $o_GSS_SucursalBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_GSS_SucursalBN->getIdSucursal() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_SucursalBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getIdUnidadProduccion() ) )
        {
            $this->setIdUnidadProduccion( $o_GSS_SucursalBN->getIdUnidadProduccion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_GSS_SucursalBN->getIdAlmacen() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_GSS_SucursalBN->getCodigoSunat() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_SucursalBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getDepartamento() ) )
        {
            $this->setDepartamento( $o_GSS_SucursalBN->getDepartamento() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getProvincia() ) )
        {
            $this->setProvincia( $o_GSS_SucursalBN->getProvincia() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getDistrito() ) )
        {
            $this->setDistrito( $o_GSS_SucursalBN->getDistrito() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getDireccion() ) )
        {
            $this->setDireccion( $o_GSS_SucursalBN->getDireccion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getTelefono() ) )
        {
            $this->setTelefono( $o_GSS_SucursalBN->getTelefono() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getLongitud() ) )
        {
            $this->setLongitud( $o_GSS_SucursalBN->getLongitud() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getLatitud() ) )
        {
            $this->setLatitud( $o_GSS_SucursalBN->getLatitud() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getUbigeo() ) )
        {
            $this->setUbigeo( $o_GSS_SucursalBN->getUbigeo() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getIp() ) )
        {
            $this->setIp( $o_GSS_SucursalBN->getIp() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getCuentaContableDefecto() ) )
        {
            $this->setCuentaContableDefecto( $o_GSS_SucursalBN->getCuentaContableDefecto() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getEstaExoneradoIGV() ) )
        {
            $this->setEstaExoneradoIGV( $o_GSS_SucursalBN->getEstaExoneradoIGV() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getRutaProveedorExt() ) )
        {
            $this->setRutaProveedorExt( $o_GSS_SucursalBN->getRutaProveedorExt() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getTokenProveedorExt() ) )
        {
            $this->setTokenProveedorExt( $o_GSS_SucursalBN->getTokenProveedorExt() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_SucursalBN->getEstado() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_SucursalBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_SucursalBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_SucursalBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_SucursalBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_SucursalBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPk( $this->getIdSucursal() );
        if ( is_null( $o_GSS_SucursalBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_Sucursal ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUnidadProduccion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUnidadProduccion";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdUnidadProduccion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAlmacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Departamento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDepartamento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvincia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Provincia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProvincia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistrito() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Distrito";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDistrito()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Direccion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDireccion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTelefono() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Telefono";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTelefono()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLongitud() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Longitud";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLongitud()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLatitud() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Latitud";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLatitud()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbigeo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Ubigeo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUbigeo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIp() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Ip";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIp()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCuentaContableDefecto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CuentaContableDefecto";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCuentaContableDefecto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstaExoneradoIGV() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EstaExoneradoIGV";
                $s_SQLQuery2 .= $s_Separator."".$this->getEstaExoneradoIGV()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaProveedorExt() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RutaProveedorExt";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRutaProveedorExt()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTokenProveedorExt() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TokenProveedorExt";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTokenProveedorExt()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_Sucursal SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUnidadProduccion() ) )
            {
                $s_SQLQuery .= $s_Separator."IdUnidadProduccion = ".$this->getIdUnidadProduccion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacen() ) )
            {
                $s_SQLQuery .= $s_Separator."IdAlmacen = '".$this->getIdAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunat = '".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamento() ) )
            {
                $s_SQLQuery .= $s_Separator."Departamento = '".$this->getDepartamento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvincia() ) )
            {
                $s_SQLQuery .= $s_Separator."Provincia = '".$this->getProvincia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistrito() ) )
            {
                $s_SQLQuery .= $s_Separator."Distrito = '".$this->getDistrito()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccion() ) )
            {
                $s_SQLQuery .= $s_Separator."Direccion = '".$this->getDireccion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTelefono() ) )
            {
                $s_SQLQuery .= $s_Separator."Telefono = '".$this->getTelefono()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLongitud() ) )
            {
                $s_SQLQuery .= $s_Separator."Longitud = '".$this->getLongitud()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLatitud() ) )
            {
                $s_SQLQuery .= $s_Separator."Latitud = '".$this->getLatitud()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbigeo() ) )
            {
                $s_SQLQuery .= $s_Separator."Ubigeo = '".$this->getUbigeo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIp() ) )
            {
                $s_SQLQuery .= $s_Separator."Ip = '".$this->getIp()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCuentaContableDefecto() ) )
            {
                $s_SQLQuery .= $s_Separator."CuentaContableDefecto = '".$this->getCuentaContableDefecto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstaExoneradoIGV() ) )
            {
                $s_SQLQuery .= $s_Separator."EstaExoneradoIGV = ".$this->getEstaExoneradoIGV()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRutaProveedorExt() ) )
            {
                $s_SQLQuery .= $s_Separator."RutaProveedorExt = '".$this->getRutaProveedorExt()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTokenProveedorExt() ) )
            {
                $s_SQLQuery .= $s_Separator."TokenProveedorExt = '".$this->getTokenProveedorExt()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdSucursal = ".$this->getIdSucursal().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_Sucursal WHERE  IdSucursal = ".$this->getIdSucursal().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>