<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Impuesto.xml */
/* Generado: 2021-10-11 19:18:18 */

/* Mantenimiento de los registros de la tabla GSS_Impuesto */
abstract class BaseGSS_ImpuestoDP extends GSS_ImpuestoBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_ImpuestoBN ) */
    public function __construct( GSS_ImpuestoBN $o_GSS_ImpuestoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_ImpuestoBN ) )
        {
            $this->setByBN( $o_GSS_ImpuestoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_ImpuestoBN */
    public function setByBN( GSS_ImpuestoBN $o_GSS_ImpuestoBN )
    {
        if ( !is_null( $o_GSS_ImpuestoBN->getIdImpuesto() ) )
        {
            $this->setIdImpuesto( $o_GSS_ImpuestoBN->getIdImpuesto() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_GSS_ImpuestoBN->getCodigo() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_ImpuestoBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getValor() ) )
        {
            $this->setValor( $o_GSS_ImpuestoBN->getValor() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_GSS_ImpuestoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getCuentaContable() ) )
        {
            $this->setCuentaContable( $o_GSS_ImpuestoBN->getCuentaContable() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getTipoRegistro() ) )
        {
            $this->setTipoRegistro( $o_GSS_ImpuestoBN->getTipoRegistro() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getFechaDesde() ) )
        {
            $this->setFechaDesde( $o_GSS_ImpuestoBN->getFechaDesde() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getFechaHasta() ) )
        {
            $this->setFechaHasta( $o_GSS_ImpuestoBN->getFechaHasta() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_ImpuestoBN->getEstado() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_ImpuestoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_ImpuestoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_ImpuestoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_ImpuestoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_ImpuestoBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_ImpuestoFN = new GSS_ImpuestoFN();
        $o_GSS_ImpuestoBN = $o_GSS_ImpuestoFN->selectByPk( $this->getIdImpuesto() );
        if ( is_null( $o_GSS_ImpuestoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_Impuesto ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdImpuesto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdImpuesto";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdImpuesto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Codigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Valor";
                $s_SQLQuery2 .= $s_Separator."".$this->getValor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCuentaContable() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CuentaContable";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCuentaContable()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoRegistro() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoRegistro";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipoRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaDesde() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaDesde";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaDesde()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaHasta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaHasta";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaHasta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_Impuesto SET ";
            $s_Separator = "";
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."Codigo = '".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValor() ) )
            {
                $s_SQLQuery .= $s_Separator."Valor = ".$this->getValor()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunat = '".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCuentaContable() ) )
            {
                $s_SQLQuery .= $s_Separator."CuentaContable = '".$this->getCuentaContable()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoRegistro() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoRegistro = '".$this->getTipoRegistro()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaDesde() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaDesde = '".$this->getFechaDesde()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaHasta() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaHasta = '".$this->getFechaHasta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdImpuesto = ".$this->getIdImpuesto().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_Impuesto WHERE  IdImpuesto = ".$this->getIdImpuesto().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>