<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Banco.xml */
/* Generado: 2020-11-19 07:05:49 */

/* Mantenimiento de los registros de la tabla GSS_Banco */
abstract class BaseGSS_BancoDP extends GSS_BancoBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_BancoBN ) */
    public function __construct( GSS_BancoBN $o_GSS_BancoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_BancoBN ) )
        {
            $this->setByBN( $o_GSS_BancoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_BancoBN */
    public function setByBN( GSS_BancoBN $o_GSS_BancoBN )
    {
        if ( !is_null( $o_GSS_BancoBN->getIdBanco() ) )
        {
            $this->setIdBanco( $o_GSS_BancoBN->getIdBanco() );
        }
        if ( !is_null( $o_GSS_BancoBN->getDescripcionLocal() ) )
        {
            $this->setDescripcionLocal( $o_GSS_BancoBN->getDescripcionLocal() );
        }
        if ( !is_null( $o_GSS_BancoBN->getCodigo() ) )
        {
            $this->setCodigo( $o_GSS_BancoBN->getCodigo() );
        }
        if ( !is_null( $o_GSS_BancoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_GSS_BancoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_GSS_BancoBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_BancoBN->getEstado() );
        }
        if ( !is_null( $o_GSS_BancoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_BancoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_BancoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_BancoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_BancoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_BancoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_BancoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_BancoBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_BancoFN = new GSS_BancoFN();
        $o_GSS_BancoBN = $o_GSS_BancoFN->selectByPk( $this->getIdBanco() );
        if ( is_null( $o_GSS_BancoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_Banco ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdBanco() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdBanco";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdBanco()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionLocal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionLocal";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionLocal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Codigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_Banco SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcionLocal() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionLocal = '".$this->getDescripcionLocal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."Codigo = '".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunat = '".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdBanco = ".$this->getIdBanco().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_Banco WHERE  IdBanco = ".$this->getIdBanco().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>