<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_RecibosEstadoLog.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla FCO_RecibosEstadoLog */
abstract class BaseFCO_RecibosEstadoLogDP extends FCO_RecibosEstadoLogBV
{
    /* Constructor ( Establece los valores desde un objeto FCO_RecibosEstadoLogBN ) */
    public function __construct( FCO_RecibosEstadoLogBN $o_FCO_RecibosEstadoLogBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_FCO_RecibosEstadoLogBN ) )
        {
            $this->setByBN( $o_FCO_RecibosEstadoLogBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto FCO_RecibosEstadoLogBN */
    public function setByBN( FCO_RecibosEstadoLogBN $o_FCO_RecibosEstadoLogBN )
    {
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getIdEstadoLog() ) )
        {
            $this->setIdEstadoLog( $o_FCO_RecibosEstadoLogBN->getIdEstadoLog() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getIdDocRecibo() ) )
        {
            $this->setIdDocRecibo( $o_FCO_RecibosEstadoLogBN->getIdDocRecibo() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getFlujoEstado() ) )
        {
            $this->setFlujoEstado( $o_FCO_RecibosEstadoLogBN->getFlujoEstado() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getNombreEstado() ) )
        {
            $this->setNombreEstado( $o_FCO_RecibosEstadoLogBN->getNombreEstado() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getComentario() ) )
        {
            $this->setComentario( $o_FCO_RecibosEstadoLogBN->getComentario() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_RecibosEstadoLogBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_RecibosEstadoLogBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_RecibosEstadoLogBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_RecibosEstadoLogBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_RecibosEstadoLogBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_FCO_RecibosEstadoLogFN = new FCO_RecibosEstadoLogFN();
        $o_FCO_RecibosEstadoLogBN = $o_FCO_RecibosEstadoLogFN->selectByPk( $this->getIdEstadoLog(), $this->getIdDocRecibo() );
        if ( is_null( $o_FCO_RecibosEstadoLogBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO FCO_RecibosEstadoLog ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdEstadoLog() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdEstadoLog";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdEstadoLog()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdDocRecibo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdDocRecibo";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdDocRecibo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFlujoEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FlujoEstado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFlujoEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombreEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NombreEstado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombreEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE FCO_RecibosEstadoLog SET ";
            $s_Separator = "";
            if ( !is_null( $this->getFlujoEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."FlujoEstado = '".$this->getFlujoEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombreEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."NombreEstado = '".$this->getNombreEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentario() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentario = '".$this->getComentario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdEstadoLog = ".$this->getIdEstadoLog()." AND  IdDocRecibo = ".$this->getIdDocRecibo().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM FCO_RecibosEstadoLog WHERE  IdEstadoLog = ".$this->getIdEstadoLog()." AND  IdDocRecibo = ".$this->getIdDocRecibo().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>