<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_OrdenRecibo.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla FCO_OrdenRecibo */
abstract class BaseFCO_OrdenReciboDP extends FCO_OrdenReciboBV
{
    /* Constructor ( Establece los valores desde un objeto FCO_OrdenReciboBN ) */
    public function __construct( FCO_OrdenReciboBN $o_FCO_OrdenReciboBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_FCO_OrdenReciboBN ) )
        {
            $this->setByBN( $o_FCO_OrdenReciboBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto FCO_OrdenReciboBN */
    public function setByBN( FCO_OrdenReciboBN $o_FCO_OrdenReciboBN )
    {
        if ( !is_null( $o_FCO_OrdenReciboBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_FCO_OrdenReciboBN->getOrdenId() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getIdDocRecibo() ) )
        {
            $this->setIdDocRecibo( $o_FCO_OrdenReciboBN->getIdDocRecibo() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getOrdenNum() ) )
        {
            $this->setOrdenNum( $o_FCO_OrdenReciboBN->getOrdenNum() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_FCO_OrdenReciboBN->getIdMoneda() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_FCO_OrdenReciboBN->getTipoCambio() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getMontoOrden() ) )
        {
            $this->setMontoOrden( $o_FCO_OrdenReciboBN->getMontoOrden() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getMontoOrdenMN() ) )
        {
            $this->setMontoOrdenMN( $o_FCO_OrdenReciboBN->getMontoOrdenMN() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getMontoOrdenME() ) )
        {
            $this->setMontoOrdenME( $o_FCO_OrdenReciboBN->getMontoOrdenME() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_OrdenReciboBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_OrdenReciboBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_OrdenReciboBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_FCO_OrdenReciboBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_OrdenReciboBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_FCO_OrdenReciboFN = new FCO_OrdenReciboFN();
        $o_FCO_OrdenReciboBN = $o_FCO_OrdenReciboFN->selectByPk( $this->getOrdenId(), $this->getIdDocRecibo() );
        if ( is_null( $o_FCO_OrdenReciboBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO FCO_OrdenRecibo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getOrdenId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenId";
                $s_SQLQuery2 .= $s_Separator."".$this->getOrdenId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdDocRecibo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdDocRecibo";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdDocRecibo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOrdenNum() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OrdenNum";
                $s_SQLQuery2 .= $s_Separator."'".$this->getOrdenNum()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdMoneda() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdMoneda";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdMoneda()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoCambio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoCambio";
                $s_SQLQuery2 .= $s_Separator."".$this->getTipoCambio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoOrden() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoOrden";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoOrden()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoOrdenMN() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoOrdenMN";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoOrdenMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoOrdenME() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoOrdenME";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoOrdenME()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE FCO_OrdenRecibo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getOrdenNum() ) )
            {
                $s_SQLQuery .= $s_Separator."OrdenNum = '".$this->getOrdenNum()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdMoneda() ) )
            {
                $s_SQLQuery .= $s_Separator."IdMoneda = '".$this->getIdMoneda()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoCambio() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoCambio = ".$this->getTipoCambio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoOrden() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoOrden = ".$this->getMontoOrden()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoOrdenMN() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoOrdenMN = ".$this->getMontoOrdenMN()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoOrdenME() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoOrdenME = ".$this->getMontoOrdenME()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  OrdenId = ".$this->getOrdenId()." AND  IdDocRecibo = ".$this->getIdDocRecibo().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM FCO_OrdenRecibo WHERE  OrdenId = ".$this->getOrdenId()." AND  IdDocRecibo = ".$this->getIdDocRecibo().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>