<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_Cierre.xml */
/* Generado: 2020-08-18 04:21:25 */

/* Mantenimiento de los registros de la tabla FCO_Cierre */
abstract class BaseFCO_CierreDP extends FCO_CierreBV
{
    /* Constructor ( Establece los valores desde un objeto FCO_CierreBN ) */
    public function __construct( FCO_CierreBN $o_FCO_CierreBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_FCO_CierreBN ) )
        {
            $this->setByBN( $o_FCO_CierreBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto FCO_CierreBN */
    public function setByBN( FCO_CierreBN $o_FCO_CierreBN )
    {
        if ( !is_null( $o_FCO_CierreBN->getIdCierre() ) )
        {
            $this->setIdCierre( $o_FCO_CierreBN->getIdCierre() );
        }
        if ( !is_null( $o_FCO_CierreBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_CierreBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_CierreBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_FCO_CierreBN->getIdSucursal() );
        }
        if ( !is_null( $o_FCO_CierreBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_FCO_CierreBN->getIdCaja() );
        }
        if ( !is_null( $o_FCO_CierreBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_FCO_CierreBN->getIdTurno() );
        }
        if ( !is_null( $o_FCO_CierreBN->getCodVendedor() ) )
        {
            $this->setCodVendedor( $o_FCO_CierreBN->getCodVendedor() );
        }
        if ( !is_null( $o_FCO_CierreBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_FCO_CierreBN->getPeriodo() );
        }
        if ( !is_null( $o_FCO_CierreBN->getFechaCierre() ) )
        {
            $this->setFechaCierre( $o_FCO_CierreBN->getFechaCierre() );
        }
        if ( !is_null( $o_FCO_CierreBN->getTotalSoles() ) )
        {
            $this->setTotalSoles( $o_FCO_CierreBN->getTotalSoles() );
        }
        if ( !is_null( $o_FCO_CierreBN->getTotalDolares() ) )
        {
            $this->setTotalDolares( $o_FCO_CierreBN->getTotalDolares() );
        }
        if ( !is_null( $o_FCO_CierreBN->getEstado() ) )
        {
            $this->setEstado( $o_FCO_CierreBN->getEstado() );
        }
        if ( !is_null( $o_FCO_CierreBN->getObservaciones() ) )
        {
            $this->setObservaciones( $o_FCO_CierreBN->getObservaciones() );
        }
        if ( !is_null( $o_FCO_CierreBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_CierreBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_CierreBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_CierreBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_CierreBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_CierreBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_CierreBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_CierreBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_FCO_CierreFN = new FCO_CierreFN();
        $o_FCO_CierreBN = $o_FCO_CierreFN->selectByPk( $this->getIdCierre() );
        if ( is_null( $o_FCO_CierreBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO FCO_Cierre ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCierre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCierre";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCierre()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCaja() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCaja";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTurno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTurno";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodVendedor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodVendedor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodVendedor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPeriodo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Periodo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPeriodo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCierre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCierre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCierre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTotalSoles() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TotalSoles";
                $s_SQLQuery2 .= $s_Separator."".$this->getTotalSoles()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTotalDolares() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TotalDolares";
                $s_SQLQuery2 .= $s_Separator."".$this->getTotalDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getObservaciones() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Observaciones";
                $s_SQLQuery2 .= $s_Separator."'".$this->getObservaciones()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE FCO_Cierre SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCaja() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCaja = ".$this->getIdCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTurno() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTurno = ".$this->getIdTurno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodVendedor() ) )
            {
                $s_SQLQuery .= $s_Separator."CodVendedor = '".$this->getCodVendedor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPeriodo() ) )
            {
                $s_SQLQuery .= $s_Separator."Periodo = '".$this->getPeriodo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCierre() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCierre = '".$this->getFechaCierre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTotalSoles() ) )
            {
                $s_SQLQuery .= $s_Separator."TotalSoles = ".$this->getTotalSoles()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTotalDolares() ) )
            {
                $s_SQLQuery .= $s_Separator."TotalDolares = ".$this->getTotalDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getObservaciones() ) )
            {
                $s_SQLQuery .= $s_Separator."Observaciones = '".$this->getObservaciones()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCierre = ".$this->getIdCierre().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM FCO_Cierre WHERE  IdCierre = ".$this->getIdCierre().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>