<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_CierreAplicacionTipo.xml */
/* Generado: 2020-08-18 04:21:25 */

/* Mantenimiento de los registros de la tabla FCO_CierreAplicacionTipo */
abstract class BaseFCO_CierreAplicacionTipoDP extends FCO_CierreAplicacionTipoBV
{
    /* Constructor ( Establece los valores desde un objeto FCO_CierreAplicacionTipoBN ) */
    public function __construct( FCO_CierreAplicacionTipoBN $o_FCO_CierreAplicacionTipoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN ) )
        {
            $this->setByBN( $o_FCO_CierreAplicacionTipoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto FCO_CierreAplicacionTipoBN */
    public function setByBN( FCO_CierreAplicacionTipoBN $o_FCO_CierreAplicacionTipoBN )
    {
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getIdCierre() ) )
        {
            $this->setIdCierre( $o_FCO_CierreAplicacionTipoBN->getIdCierre() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getIdTipoPago() ) )
        {
            $this->setIdTipoPago( $o_FCO_CierreAplicacionTipoBN->getIdTipoPago() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getIdMoneda() ) )
        {
            $this->setIdMoneda( $o_FCO_CierreAplicacionTipoBN->getIdMoneda() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getMonedaDes() ) )
        {
            $this->setMonedaDes( $o_FCO_CierreAplicacionTipoBN->getMonedaDes() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getCierreCantTrans() ) )
        {
            $this->setCierreCantTrans( $o_FCO_CierreAplicacionTipoBN->getCierreCantTrans() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getCierreMontoTrans() ) )
        {
            $this->setCierreMontoTrans( $o_FCO_CierreAplicacionTipoBN->getCierreMontoTrans() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_CierreAplicacionTipoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_CierreAplicacionTipoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_CierreAplicacionTipoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_CierreAplicacionTipoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_CierreAplicacionTipoBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_FCO_CierreAplicacionTipoFN = new FCO_CierreAplicacionTipoFN();
        $o_FCO_CierreAplicacionTipoBN = $o_FCO_CierreAplicacionTipoFN->selectByPk( $this->getIdCierre(), $this->getIdTipoPago(), $this->getIdMoneda() );
        if ( is_null( $o_FCO_CierreAplicacionTipoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO FCO_CierreAplicacionTipo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCierre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCierre";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCierre()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoPago() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoPago";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdTipoPago()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdMoneda() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdMoneda";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdMoneda()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMonedaDes() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MonedaDes";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMonedaDes()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCierreCantTrans() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CierreCantTrans";
                $s_SQLQuery2 .= $s_Separator."".$this->getCierreCantTrans()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCierreMontoTrans() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CierreMontoTrans";
                $s_SQLQuery2 .= $s_Separator."".$this->getCierreMontoTrans()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE FCO_CierreAplicacionTipo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getMonedaDes() ) )
            {
                $s_SQLQuery .= $s_Separator."MonedaDes = '".$this->getMonedaDes()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCierreCantTrans() ) )
            {
                $s_SQLQuery .= $s_Separator."CierreCantTrans = ".$this->getCierreCantTrans()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCierreMontoTrans() ) )
            {
                $s_SQLQuery .= $s_Separator."CierreMontoTrans = ".$this->getCierreMontoTrans()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCierre = ".$this->getIdCierre()." AND  IdTipoPago = ".$this->getIdTipoPago()." AND  IdMoneda = '".$this->getIdMoneda()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM FCO_CierreAplicacionTipo WHERE  IdCierre = ".$this->getIdCierre()." AND  IdTipoPago = ".$this->getIdTipoPago()." AND  IdMoneda = '".$this->getIdMoneda()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>