<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_Caja.xml */
/* Generado: 2020-08-18 04:21:25 */

/* Mantenimiento de los registros de la tabla FCO_Caja */
abstract class BaseFCO_CajaDP extends FCO_CajaBV
{
    /* Constructor ( Establece los valores desde un objeto FCO_CajaBN ) */
    public function __construct( FCO_CajaBN $o_FCO_CajaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_FCO_CajaBN ) )
        {
            $this->setByBN( $o_FCO_CajaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto FCO_CajaBN */
    public function setByBN( FCO_CajaBN $o_FCO_CajaBN )
    {
        if ( !is_null( $o_FCO_CajaBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_FCO_CajaBN->getIdCaja() );
        }
        if ( !is_null( $o_FCO_CajaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_CajaBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_CajaBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_FCO_CajaBN->getIdSucursal() );
        }
        if ( !is_null( $o_FCO_CajaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_FCO_CajaBN->getDescripcion() );
        }
        if ( !is_null( $o_FCO_CajaBN->getEstado() ) )
        {
            $this->setEstado( $o_FCO_CajaBN->getEstado() );
        }
        if ( !is_null( $o_FCO_CajaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_CajaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_CajaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_CajaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_CajaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_CajaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_CajaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_CajaBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_FCO_CajaFN = new FCO_CajaFN();
        $o_FCO_CajaBN = $o_FCO_CajaFN->selectByPk( $this->getIdCaja() );
        if ( is_null( $o_FCO_CajaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO FCO_Caja ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCaja() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCaja";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE FCO_Caja SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCaja = ".$this->getIdCaja().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM FCO_Caja WHERE  IdCaja = ".$this->getIdCaja().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>