<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TipoDocumento.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Mantenimiento de los registros de la tabla ALM_TipoDocumento */
abstract class BaseALM_TipoDocumentoDP extends ALM_TipoDocumentoBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_TipoDocumentoBN ) */
    public function __construct( ALM_TipoDocumentoBN $o_ALM_TipoDocumentoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_TipoDocumentoBN ) )
        {
            $this->setByBN( $o_ALM_TipoDocumentoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_TipoDocumentoBN */
    public function setByBN( ALM_TipoDocumentoBN $o_ALM_TipoDocumentoBN )
    {
        if ( !is_null( $o_ALM_TipoDocumentoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_ALM_TipoDocumentoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_ALM_TipoDocumentoBN->getCodigoSunat() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_TipoDocumentoBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getEsFiscalFlag() ) )
        {
            $this->setEsFiscalFlag( $o_ALM_TipoDocumentoBN->getEsFiscalFlag() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getTransaccionSistemaFlag() ) )
        {
            $this->setTransaccionSistemaFlag( $o_ALM_TipoDocumentoBN->getTransaccionSistemaFlag() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_TipoDocumentoBN->getEstado() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_TipoDocumentoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_TipoDocumentoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_TipoDocumentoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_TipoDocumentoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_TipoDocumentoBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN();
        $o_ALM_TipoDocumentoBN = $o_ALM_TipoDocumentoFN->selectByPk( $this->getIdTipoDocumento() );
        if ( is_null( $o_ALM_TipoDocumentoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_TipoDocumento ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdTipoDocumento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoDocumento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTipoDocumento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsFiscalFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EsFiscalFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEsFiscalFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransaccionSistemaFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TransaccionSistemaFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTransaccionSistemaFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_TipoDocumento SET ";
            $s_Separator = "";
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunat = '".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsFiscalFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."EsFiscalFlag = '".$this->getEsFiscalFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTransaccionSistemaFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."TransaccionSistemaFlag = '".$this->getTransaccionSistemaFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdTipoDocumento = '".$this->getIdTipoDocumento()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_TipoDocumento WHERE  IdTipoDocumento = '".$this->getIdTipoDocumento()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>