<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_InventarioFisicoPesaje.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Mantenimiento de los registros de la tabla ALM_InventarioFisicoPesaje */
abstract class BaseALM_InventarioFisicoPesajeDP extends ALM_InventarioFisicoPesajeBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_InventarioFisicoPesajeBN ) */
    public function __construct( ALM_InventarioFisicoPesajeBN $o_ALM_InventarioFisicoPesajeBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN ) )
        {
            $this->setByBN( $o_ALM_InventarioFisicoPesajeBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_InventarioFisicoPesajeBN */
    public function setByBN( ALM_InventarioFisicoPesajeBN $o_ALM_InventarioFisicoPesajeBN )
    {
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_InventarioFisicoPesajeBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdNumeroInventario() ) )
        {
            $this->setIdNumeroInventario( $o_ALM_InventarioFisicoPesajeBN->getIdNumeroInventario() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_InventarioFisicoPesajeBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdPesaje() ) )
        {
            $this->setIdPesaje( $o_ALM_InventarioFisicoPesajeBN->getIdPesaje() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getStockFisico() ) )
        {
            $this->setStockFisico( $o_ALM_InventarioFisicoPesajeBN->getStockFisico() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getStockUnidades() ) )
        {
            $this->setStockUnidades( $o_ALM_InventarioFisicoPesajeBN->getStockUnidades() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdAlmacenDestino() ) )
        {
            $this->setIdAlmacenDestino( $o_ALM_InventarioFisicoPesajeBN->getIdAlmacenDestino() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdItemDestino() ) )
        {
            $this->setIdItemDestino( $o_ALM_InventarioFisicoPesajeBN->getIdItemDestino() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_ALM_InventarioFisicoPesajeBN->getIdUnidad() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdTipoDocumentoRef() ) )
        {
            $this->setIdTipoDocumentoRef( $o_ALM_InventarioFisicoPesajeBN->getIdTipoDocumentoRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdNumeroDocumentoRef() ) )
        {
            $this->setIdNumeroDocumentoRef( $o_ALM_InventarioFisicoPesajeBN->getIdNumeroDocumentoRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getIdSecuenciaRef() ) )
        {
            $this->setIdSecuenciaRef( $o_ALM_InventarioFisicoPesajeBN->getIdSecuenciaRef() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_InventarioFisicoPesajeBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_InventarioFisicoPesajeBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_InventarioFisicoPesajeBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_InventarioFisicoPesajeBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoPesajeBN->getLongitud() ) )
        {
            $this->setLongitud( $o_ALM_InventarioFisicoPesajeBN->getLongitud() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_InventarioFisicoPesajeFN = new ALM_InventarioFisicoPesajeFN();
        $o_ALM_InventarioFisicoPesajeBN = $o_ALM_InventarioFisicoPesajeFN->selectByPk( $this->getIdCompania(), $this->getIdNumeroInventario(), $this->getIdSecuencia(), $this->getIdPesaje() );
        if ( is_null( $o_ALM_InventarioFisicoPesajeBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_InventarioFisicoPesaje ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdNumeroInventario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdNumeroInventario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdNumeroInventario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSecuencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdPesaje() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPesaje";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdPesaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockFisico() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockFisico";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockFisico()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockUnidades() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockUnidades";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockUnidades()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacenDestino() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAlmacenDestino";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdAlmacenDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItemDestino() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItemDestino";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItemDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUnidad() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUnidad";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdUnidad()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoDocumentoRef() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoDocumentoRef";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTipoDocumentoRef()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdNumeroDocumentoRef() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdNumeroDocumentoRef";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdNumeroDocumentoRef()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSecuenciaRef() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSecuenciaRef";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSecuenciaRef()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLongitud() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Longitud";
                $s_SQLQuery2 .= $s_Separator."".$this->getLongitud()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_InventarioFisicoPesaje SET ";
            $s_Separator = "";
            if ( !is_null( $this->getStockFisico() ) )
            {
                $s_SQLQuery .= $s_Separator."StockFisico = ".$this->getStockFisico()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockUnidades() ) )
            {
                $s_SQLQuery .= $s_Separator."StockUnidades = ".$this->getStockUnidades()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacenDestino() ) )
            {
                $s_SQLQuery .= $s_Separator."IdAlmacenDestino = '".$this->getIdAlmacenDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItemDestino() ) )
            {
                $s_SQLQuery .= $s_Separator."IdItemDestino = '".$this->getIdItemDestino()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUnidad() ) )
            {
                $s_SQLQuery .= $s_Separator."IdUnidad = '".$this->getIdUnidad()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoDocumentoRef() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTipoDocumentoRef = '".$this->getIdTipoDocumentoRef()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdNumeroDocumentoRef() ) )
            {
                $s_SQLQuery .= $s_Separator."IdNumeroDocumentoRef = '".$this->getIdNumeroDocumentoRef()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSecuenciaRef() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSecuenciaRef = ".$this->getIdSecuenciaRef()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLongitud() ) )
            {
                $s_SQLQuery .= $s_Separator."Longitud = ".$this->getLongitud()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania()." AND  IdNumeroInventario = '".$this->getIdNumeroInventario()."' AND  IdSecuencia = ".$this->getIdSecuencia()." AND  IdPesaje = ".$this->getIdPesaje().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_InventarioFisicoPesaje WHERE  IdCompania = ".$this->getIdCompania()." AND  IdNumeroInventario = '".$this->getIdNumeroInventario()."' AND  IdSecuencia = ".$this->getIdSecuencia()." AND  IdPesaje = ".$this->getIdPesaje().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>