<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaLog.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Mantenimiento de los registros de la tabla ALM_CajaChicaLog */
abstract class BaseALM_CajaChicaLogDP extends ALM_CajaChicaLogBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_CajaChicaLogBN ) */
    public function __construct( ALM_CajaChicaLogBN $o_ALM_CajaChicaLogBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_CajaChicaLogBN ) )
        {
            $this->setByBN( $o_ALM_CajaChicaLogBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_CajaChicaLogBN */
    public function setByBN( ALM_CajaChicaLogBN $o_ALM_CajaChicaLogBN )
    {
        if ( !is_null( $o_ALM_CajaChicaLogBN->getIdCajaLog() ) )
        {
            $this->setIdCajaLog( $o_ALM_CajaChicaLogBN->getIdCajaLog() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_ALM_CajaChicaLogBN->getIdCaja() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getTipoLog() ) )
        {
            $this->setTipoLog( $o_ALM_CajaChicaLogBN->getTipoLog() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getValorAnterior() ) )
        {
            $this->setValorAnterior( $o_ALM_CajaChicaLogBN->getValorAnterior() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getValorNuevo() ) )
        {
            $this->setValorNuevo( $o_ALM_CajaChicaLogBN->getValorNuevo() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_CajaChicaLogBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaLogBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_CajaChicaLogBN->getUsuarioCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_CajaChicaLogFN = new ALM_CajaChicaLogFN();
        $o_ALM_CajaChicaLogBN = $o_ALM_CajaChicaLogFN->selectByPk( $this->getIdCajaLog() );
        if ( is_null( $o_ALM_CajaChicaLogBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_CajaChicaLog ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCajaLog() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCajaLog";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCajaLog()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCaja() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCaja";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoLog() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoLog";
                $s_SQLQuery2 .= $s_Separator."".$this->getTipoLog()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValorAnterior() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ValorAnterior";
                $s_SQLQuery2 .= $s_Separator."'".$this->getValorAnterior()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValorNuevo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ValorNuevo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getValorNuevo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_CajaChicaLog SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCaja() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCaja = ".$this->getIdCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoLog() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoLog = ".$this->getTipoLog()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValorAnterior() ) )
            {
                $s_SQLQuery .= $s_Separator."ValorAnterior = '".$this->getValorAnterior()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getValorNuevo() ) )
            {
                $s_SQLQuery .= $s_Separator."ValorNuevo = '".$this->getValorNuevo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCajaLog = ".$this->getIdCajaLog().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_CajaChicaLog WHERE  IdCajaLog = ".$this->getIdCajaLog().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>