<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_AlmacenGrupo.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Mantenimiento de los registros de la tabla ALM_AlmacenGrupo */
abstract class BaseALM_AlmacenGrupoDP extends ALM_AlmacenGrupoBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_AlmacenGrupoBN ) */
    public function __construct( ALM_AlmacenGrupoBN $o_ALM_AlmacenGrupoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_AlmacenGrupoBN ) )
        {
            $this->setByBN( $o_ALM_AlmacenGrupoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_AlmacenGrupoBN */
    public function setByBN( ALM_AlmacenGrupoBN $o_ALM_AlmacenGrupoBN )
    {
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getIdAlmacenGrupo() ) )
        {
            $this->setIdAlmacenGrupo( $o_ALM_AlmacenGrupoBN->getIdAlmacenGrupo() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_AlmacenGrupoBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_AlmacenGrupoBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_AlmacenGrupoBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_AlmacenGrupoBN->getEstado() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_AlmacenGrupoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_AlmacenGrupoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_AlmacenGrupoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_AlmacenGrupoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_AlmacenGrupoBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_AlmacenGrupoFN = new ALM_AlmacenGrupoFN();
        $o_ALM_AlmacenGrupoBN = $o_ALM_AlmacenGrupoFN->selectByPk( $this->getIdAlmacenGrupo() );
        if ( is_null( $o_ALM_AlmacenGrupoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_AlmacenGrupo ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdAlmacenGrupo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAlmacenGrupo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdAlmacenGrupo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_AlmacenGrupo SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery .= $s_Separator."IdCompania = ".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdAlmacenGrupo = '".$this->getIdAlmacenGrupo()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_AlmacenGrupo WHERE  IdAlmacenGrupo = '".$this->getIdAlmacenGrupo()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>