<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_ProductoFinalDet.xml */
/* Generado: 2021-02-23 17:19:35 */

/* Validacion del contenido de los campos campos de la tabla VTA_ProductoFinalDet */
abstract class BaseVTA_ProductoFinalDetBV extends VTA_ProductoFinalDetBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo ProFinalDetId */
    public function setProFinalDetId( $i_ProFinalDetId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ProFinalDetId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ProFinalDetId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProFinalDetId( $i_ProFinalDetId );
        return true;
    }

    /* Valida y establece el valor del campo ProFinalId */
    public function setProFinalId( $i_ProFinalId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ProFinalId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ProFinalId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProFinalId( $i_ProFinalId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $i_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $i_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $s_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Secuencia, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $s_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $i_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $i_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo DetalleDescripcion */
    public function setDetalleDescripcion( $s_DetalleDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DetalleDescripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DetalleDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDetalleDescripcion( $s_DetalleDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo CantidadRecibida */
    public function setCantidadRecibida( $f_CantidadRecibida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadRecibida, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadRecibida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadRecibida( $f_CantidadRecibida );
        return true;
    }

    /* Valida y establece el valor del campo PesoUnitario */
    public function setPesoUnitario( $f_PesoUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PesoUnitario, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo PesoUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPesoUnitario( $f_PesoUnitario );
        return true;
    }

    /* Valida y establece el valor del campo PesoTotal */
    public function setPesoTotal( $f_PesoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PesoTotal, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo PesoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPesoTotal( $f_PesoTotal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioAlq */
    public function setPrecioUnitarioAlq( $f_PrecioUnitarioAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioAlq, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioAlq( $f_PrecioUnitarioAlq );
        return true;
    }

    /* Valida y establece el valor del campo ImpuestoUnitarioAlq */
    public function setImpuestoUnitarioAlq( $f_ImpuestoUnitarioAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ImpuestoUnitarioAlq, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ImpuestoUnitarioAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpuestoUnitarioAlq( $f_ImpuestoUnitarioAlq );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioConIGVAlq */
    public function setPrecioUnitarioConIGVAlq( $f_PrecioUnitarioConIGVAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioConIGVAlq, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioConIGVAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioConIGVAlq( $f_PrecioUnitarioConIGVAlq );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotalAlq */
    public function setMontoSubTotalAlq( $f_MontoSubTotalAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotalAlq, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSubTotalAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotalAlq( $f_MontoSubTotalAlq );
        return true;
    }

    /* Valida y establece el valor del campo ImpuestoTotalAlq */
    public function setImpuestoTotalAlq( $f_ImpuestoTotalAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ImpuestoTotalAlq, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ImpuestoTotalAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpuestoTotalAlq( $f_ImpuestoTotalAlq );
        return true;
    }

    /* Valida y establece el valor del campo TotalConIGVAlq */
    public function setTotalConIGVAlq( $f_TotalConIGVAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalConIGVAlq, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo TotalConIGVAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalConIGVAlq( $f_TotalConIGVAlq );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioVal */
    public function setPrecioUnitarioVal( $f_PrecioUnitarioVal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioVal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioVal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioVal( $f_PrecioUnitarioVal );
        return true;
    }

    /* Valida y establece el valor del campo ImpuestoUnitarioVal */
    public function setImpuestoUnitarioVal( $f_ImpuestoUnitarioVal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ImpuestoUnitarioVal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ImpuestoUnitarioVal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpuestoUnitarioVal( $f_ImpuestoUnitarioVal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioConIGVVal */
    public function setPrecioUnitarioConIGVVal( $f_PrecioUnitarioConIGVVal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioConIGVVal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioConIGVVal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioConIGVVal( $f_PrecioUnitarioConIGVVal );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotalVal */
    public function setMontoSubTotalVal( $f_MontoSubTotalVal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotalVal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSubTotalVal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotalVal( $f_MontoSubTotalVal );
        return true;
    }

    /* Valida y establece el valor del campo ImpuestoTotalVal */
    public function setImpuestoTotalVal( $f_ImpuestoTotalVal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ImpuestoTotalVal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ImpuestoTotalVal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpuestoTotalVal( $f_ImpuestoTotalVal );
        return true;
    }

    /* Valida y establece el valor del campo TotalConIGVVal */
    public function setTotalConIGVVal( $f_TotalConIGVVal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalConIGVVal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo TotalConIGVVal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalConIGVVal( $f_TotalConIGVVal );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setProFinalDetId( $this->getProFinalDetId(), false );
        $this->setProFinalId( $this->getProFinalId(), true );
        $this->setOrdenId( $this->getOrdenId(), true );
        $this->setSecuencia( $this->getSecuencia(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setDetalleDescripcion( $this->getDetalleDescripcion(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setCantidadRecibida( $this->getCantidadRecibida(), true );
        $this->setPesoUnitario( $this->getPesoUnitario(), true );
        $this->setPesoTotal( $this->getPesoTotal(), true );
        $this->setPrecioUnitarioAlq( $this->getPrecioUnitarioAlq(), true );
        $this->setImpuestoUnitarioAlq( $this->getImpuestoUnitarioAlq(), true );
        $this->setPrecioUnitarioConIGVAlq( $this->getPrecioUnitarioConIGVAlq(), true );
        $this->setMontoSubTotalAlq( $this->getMontoSubTotalAlq(), true );
        $this->setImpuestoTotalAlq( $this->getImpuestoTotalAlq(), true );
        $this->setTotalConIGVAlq( $this->getTotalConIGVAlq(), true );
        $this->setPrecioUnitarioVal( $this->getPrecioUnitarioVal(), true );
        $this->setImpuestoUnitarioVal( $this->getImpuestoUnitarioVal(), true );
        $this->setPrecioUnitarioConIGVVal( $this->getPrecioUnitarioConIGVVal(), true );
        $this->setMontoSubTotalVal( $this->getMontoSubTotalVal(), true );
        $this->setImpuestoTotalVal( $this->getImpuestoTotalVal(), true );
        $this->setTotalConIGVVal( $this->getTotalConIGVVal(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>