<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_ProductoFinal.xml */
/* Generado: 2021-04-07 18:25:48 */

/* Validacion del contenido de los campos campos de la tabla VTA_ProductoFinal */
abstract class BaseVTA_ProductoFinalBV extends VTA_ProductoFinalBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo ProFinalId */
    public function setProFinalId( $i_ProFinalId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ProFinalId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ProFinalId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProFinalId( $i_ProFinalId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $i_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $i_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo ItemTipoClase */
    public function setItemTipoClase( $i_ItemTipoClase, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ItemTipoClase, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ItemTipoClase ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItemTipoClase( $i_ItemTipoClase );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $s_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Secuencia, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $s_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdOrdenPrdCab */
    public function setIdOrdenPrdCab( $i_IdOrdenPrdCab, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenPrdCab, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenPrdCab ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenPrdCab( $i_IdOrdenPrdCab );
        return true;
    }

    /* Valida y establece el valor del campo IdLinea */
    public function setIdLinea( $i_IdLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdLinea, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLinea( $i_IdLinea );
        return true;
    }

    /* Valida y establece el valor del campo IdFamilia */
    public function setIdFamilia( $i_IdFamilia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdFamilia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdFamilia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdFamilia( $i_IdFamilia );
        return true;
    }

    /* Valida y establece el valor del campo IdSubFamilia */
    public function setIdSubFamilia( $i_IdSubFamilia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSubFamilia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSubFamilia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSubFamilia( $i_IdSubFamilia );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $i_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $i_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo IdItemTipo */
    public function setIdItemTipo( $s_IdItemTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemTipo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdItemTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemTipo( $s_IdItemTipo );
        return true;
    }

    /* Valida y establece el valor del campo DetalleDescripcion */
    public function setDetalleDescripcion( $s_DetalleDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DetalleDescripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DetalleDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDetalleDescripcion( $s_DetalleDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo Altura */
    public function setAltura( $f_Altura, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Altura, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Altura ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAltura( $f_Altura );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo CantidadRecibida */
    public function setCantidadRecibida( $f_CantidadRecibida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadRecibida, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadRecibida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadRecibida( $f_CantidadRecibida );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo ImpuestoUnitario */
    public function setImpuestoUnitario( $f_ImpuestoUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ImpuestoUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ImpuestoUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpuestoUnitario( $f_ImpuestoUnitario );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioConIGV */
    public function setPrecioUnitarioConIGV( $f_PrecioUnitarioConIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioConIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioConIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioConIGV( $f_PrecioUnitarioConIGV );
        return true;
    }

    /* Valida y establece el valor del campo SubTotalSinIGV */
    public function setSubTotalSinIGV( $f_SubTotalSinIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SubTotalSinIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SubTotalSinIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSubTotalSinIGV( $f_SubTotalSinIGV );
        return true;
    }

    /* Valida y establece el valor del campo ImpuestoSubTotal */
    public function setImpuestoSubTotal( $f_ImpuestoSubTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ImpuestoSubTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ImpuestoSubTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpuestoSubTotal( $f_ImpuestoSubTotal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioTotalConIGV */
    public function setPrecioTotalConIGV( $f_PrecioTotalConIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioTotalConIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioTotalConIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioTotalConIGV( $f_PrecioTotalConIGV );
        return true;
    }

    /* Valida y establece el valor del campo DsctoTipoCod */
    public function setDsctoTipoCod( $s_DsctoTipoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DsctoTipoCod, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo DsctoTipoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDsctoTipoCod( $s_DsctoTipoCod );
        return true;
    }

    /* Valida y establece el valor del campo DsctoCod */
    public function setDsctoCod( $s_DsctoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DsctoCod, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo DsctoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDsctoCod( $s_DsctoCod );
        return true;
    }

    /* Valida y establece el valor del campo DsctoTotal */
    public function setDsctoTotal( $f_DsctoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_DsctoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo DsctoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDsctoTotal( $f_DsctoTotal );
        return true;
    }

    /* Valida y establece el valor del campo BaseImponible */
    public function setBaseImponible( $f_BaseImponible, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_BaseImponible, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo BaseImponible ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setBaseImponible( $f_BaseImponible );
        return true;
    }

    /* Valida y establece el valor del campo ImpuestoConDscto */
    public function setImpuestoConDscto( $f_ImpuestoConDscto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ImpuestoConDscto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ImpuestoConDscto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpuestoConDscto( $f_ImpuestoConDscto );
        return true;
    }

    /* Valida y establece el valor del campo TotalaPagar */
    public function setTotalaPagar( $f_TotalaPagar, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalaPagar, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo TotalaPagar ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalaPagar( $f_TotalaPagar );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setProFinalId( $this->getProFinalId(), false );
        $this->setOrdenId( $this->getOrdenId(), true );
        $this->setItemTipoClase( $this->getItemTipoClase(), true );
        $this->setSecuencia( $this->getSecuencia(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdOrdenPrdCab( $this->getIdOrdenPrdCab(), true );
        $this->setIdLinea( $this->getIdLinea(), true );
        $this->setIdFamilia( $this->getIdFamilia(), true );
        $this->setIdSubFamilia( $this->getIdSubFamilia(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setIdItemTipo( $this->getIdItemTipo(), true );
        $this->setDetalleDescripcion( $this->getDetalleDescripcion(), true );
        $this->setAltura( $this->getAltura(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setCantidadRecibida( $this->getCantidadRecibida(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setImpuestoUnitario( $this->getImpuestoUnitario(), true );
        $this->setPrecioUnitarioConIGV( $this->getPrecioUnitarioConIGV(), true );
        $this->setSubTotalSinIGV( $this->getSubTotalSinIGV(), true );
        $this->setImpuestoSubTotal( $this->getImpuestoSubTotal(), true );
        $this->setPrecioTotalConIGV( $this->getPrecioTotalConIGV(), true );
        $this->setDsctoTipoCod( $this->getDsctoTipoCod(), true );
        $this->setDsctoCod( $this->getDsctoCod(), true );
        $this->setDsctoTotal( $this->getDsctoTotal(), true );
        $this->setBaseImponible( $this->getBaseImponible(), true );
        $this->setImpuestoConDscto( $this->getImpuestoConDscto(), true );
        $this->setTotalaPagar( $this->getTotalaPagar(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>