<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenDetalle.xml */
/* Generado: 2022-02-07 02:14:15 */

/* Validacion del contenido de los campos campos de la tabla VTA_OrdenDetalle */
abstract class BaseVTA_OrdenDetalleBV extends VTA_OrdenDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $i_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $i_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleNum */
    public function setOrdenDetalleNum( $i_OrdenDetalleNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenDetalleNum, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenDetalleNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleNum( $i_OrdenDetalleNum );
        return true;
    }

    /* Valida y establece el valor del campo ItemTipo */
    public function setItemTipo( $s_ItemTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ItemTipo, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ItemTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItemTipo( $s_ItemTipo );
        return true;
    }

    /* Valida y establece el valor del campo ItemCod */
    public function setItemCod( $s_ItemCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ItemCod, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ItemCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItemCod( $s_ItemCod );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenCod */
    public function setAlmacenCod( $s_AlmacenCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenCod, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo AlmacenCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenCod( $s_AlmacenCod );
        return true;
    }

    /* Valida y establece el valor del campo LoteNum */
    public function setLoteNum( $s_LoteNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LoteNum, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo LoteNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLoteNum( $s_LoteNum );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $i_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $i_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo IdItemTipo */
    public function setIdItemTipo( $s_IdItemTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemTipo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdItemTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemTipo( $s_IdItemTipo );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleDescripcion */
    public function setOrdenDetalleDescripcion( $s_OrdenDetalleDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenDetalleDescripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo OrdenDetalleDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleDescripcion( $s_OrdenDetalleDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetallePrecioNivel */
    public function setOrdenDetallePrecioNivel( $s_OrdenDetallePrecioNivel, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenDetallePrecioNivel, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo OrdenDetallePrecioNivel ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetallePrecioNivel( $s_OrdenDetallePrecioNivel );
        return true;
    }

    /* Valida y establece el valor del campo CostoUnidadIncImpuesto */
    public function setCostoUnidadIncImpuesto( $f_CostoUnidadIncImpuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoUnidadIncImpuesto, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo CostoUnidadIncImpuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoUnidadIncImpuesto( $f_CostoUnidadIncImpuesto );
        return true;
    }

    /* Valida y establece el valor del campo CostoUnidadIncImpuestoMN */
    public function setCostoUnidadIncImpuestoMN( $f_CostoUnidadIncImpuestoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoUnidadIncImpuestoMN, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo CostoUnidadIncImpuestoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoUnidadIncImpuestoMN( $f_CostoUnidadIncImpuestoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetallePrecioUnidad */
    public function setOrdenDetallePrecioUnidad( $f_OrdenDetallePrecioUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetallePrecioUnidad, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo OrdenDetallePrecioUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetallePrecioUnidad( $f_OrdenDetallePrecioUnidad );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetallePrecioUnidadMN */
    public function setOrdenDetallePrecioUnidadMN( $f_OrdenDetallePrecioUnidadMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetallePrecioUnidadMN, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo OrdenDetallePrecioUnidadMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetallePrecioUnidadMN( $f_OrdenDetallePrecioUnidadMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleDsctoUnidad */
    public function setOrdenDetalleDsctoUnidad( $f_OrdenDetalleDsctoUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleDsctoUnidad, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenDetalleDsctoUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleDsctoUnidad( $f_OrdenDetalleDsctoUnidad );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleDsctoUnidadMN */
    public function setOrdenDetalleDsctoUnidadMN( $f_OrdenDetalleDsctoUnidadMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleDsctoUnidadMN, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenDetalleDsctoUnidadMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleDsctoUnidadMN( $f_OrdenDetalleDsctoUnidadMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleAfectoImpuesto */
    public function setOrdenDetalleAfectoImpuesto( $s_OrdenDetalleAfectoImpuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenDetalleAfectoImpuesto, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenDetalleAfectoImpuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleAfectoImpuesto( $s_OrdenDetalleAfectoImpuesto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleImpuestoUnidad */
    public function setOrdenDetalleImpuestoUnidad( $f_OrdenDetalleImpuestoUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleImpuestoUnidad, "DECIMAL", 12, 4, false ) )
            {
                throw new Exception( "El campo OrdenDetalleImpuestoUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleImpuestoUnidad( $f_OrdenDetalleImpuestoUnidad );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleImpuestoUnidadMN */
    public function setOrdenDetalleImpuestoUnidadMN( $f_OrdenDetalleImpuestoUnidadMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleImpuestoUnidadMN, "DECIMAL", 12, 4, false ) )
            {
                throw new Exception( "El campo OrdenDetalleImpuestoUnidadMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleImpuestoUnidadMN( $f_OrdenDetalleImpuestoUnidadMN );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnidadIncImpuesto */
    public function setPrecioUnidadIncImpuesto( $f_PrecioUnidadIncImpuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnidadIncImpuesto, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo PrecioUnidadIncImpuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnidadIncImpuesto( $f_PrecioUnidadIncImpuesto );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnidadIncImpuestoMN */
    public function setPrecioUnidadIncImpuestoMN( $f_PrecioUnidadIncImpuestoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnidadIncImpuestoMN, "DECIMAL", 16, 10, false ) )
            {
                throw new Exception( "El campo PrecioUnidadIncImpuestoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnidadIncImpuestoMN( $f_PrecioUnidadIncImpuestoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleCantidad */
    public function setOrdenDetalleCantidad( $f_OrdenDetalleCantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleCantidad, "DECIMAL", 6, 2, false ) )
            {
                throw new Exception( "El campo OrdenDetalleCantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleCantidad( $f_OrdenDetalleCantidad );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleSubTotalVenta */
    public function setOrdenDetalleSubTotalVenta( $f_OrdenDetalleSubTotalVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleSubTotalVenta, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenDetalleSubTotalVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleSubTotalVenta( $f_OrdenDetalleSubTotalVenta );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleSubTotalVentaMN */
    public function setOrdenDetalleSubTotalVentaMN( $f_OrdenDetalleSubTotalVentaMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleSubTotalVentaMN, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenDetalleSubTotalVentaMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleSubTotalVentaMN( $f_OrdenDetalleSubTotalVentaMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleSubTotalImpuesto */
    public function setOrdenDetalleSubTotalImpuesto( $f_OrdenDetalleSubTotalImpuesto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleSubTotalImpuesto, "DECIMAL", 12, 4, false ) )
            {
                throw new Exception( "El campo OrdenDetalleSubTotalImpuesto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleSubTotalImpuesto( $f_OrdenDetalleSubTotalImpuesto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleSubTotalImpuestoMN */
    public function setOrdenDetalleSubTotalImpuestoMN( $f_OrdenDetalleSubTotalImpuestoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleSubTotalImpuestoMN, "DECIMAL", 12, 4, false ) )
            {
                throw new Exception( "El campo OrdenDetalleSubTotalImpuestoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleSubTotalImpuestoMN( $f_OrdenDetalleSubTotalImpuestoMN );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleSubTotalNeto */
    public function setOrdenDetalleSubTotalNeto( $f_OrdenDetalleSubTotalNeto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleSubTotalNeto, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenDetalleSubTotalNeto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleSubTotalNeto( $f_OrdenDetalleSubTotalNeto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleSubTotalNetoMN */
    public function setOrdenDetalleSubTotalNetoMN( $f_OrdenDetalleSubTotalNetoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_OrdenDetalleSubTotalNetoMN, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo OrdenDetalleSubTotalNetoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleSubTotalNetoMN( $f_OrdenDetalleSubTotalNetoMN );
        return true;
    }

    /* Valida y establece el valor del campo DocRefTipoCod */
    public function setDocRefTipoCod( $s_DocRefTipoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocRefTipoCod, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo DocRefTipoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocRefTipoCod( $s_DocRefTipoCod );
        return true;
    }

    /* Valida y establece el valor del campo DocRefNum */
    public function setDocRefNum( $s_DocRefNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocRefNum, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo DocRefNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocRefNum( $s_DocRefNum );
        return true;
    }

    /* Valida y establece el valor del campo DocRefId */
    public function setDocRefId( $i_DocRefId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DocRefId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DocRefId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocRefId( $i_DocRefId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleObs */
    public function setOrdenDetalleObs( $s_OrdenDetalleObs, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenDetalleObs, "VARCHAR", 310, 0, false ) )
            {
                throw new Exception( "El campo OrdenDetalleObs ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleObs( $s_OrdenDetalleObs );
        return true;
    }

    /* Valida y establece el valor del campo OrdenDetalleEstado */
    public function setOrdenDetalleEstado( $s_OrdenDetalleEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenDetalleEstado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenDetalleEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenDetalleEstado( $s_OrdenDetalleEstado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setOrdenId( $this->getOrdenId(), false );
        $this->setOrdenDetalleNum( $this->getOrdenDetalleNum(), false );
        $this->setItemTipo( $this->getItemTipo(), true );
        $this->setItemCod( $this->getItemCod(), true );
        $this->setAlmacenCod( $this->getAlmacenCod(), true );
        $this->setLoteNum( $this->getLoteNum(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setIdItemTipo( $this->getIdItemTipo(), true );
        $this->setOrdenDetalleDescripcion( $this->getOrdenDetalleDescripcion(), true );
        $this->setOrdenDetallePrecioNivel( $this->getOrdenDetallePrecioNivel(), true );
        $this->setCostoUnidadIncImpuesto( $this->getCostoUnidadIncImpuesto(), true );
        $this->setCostoUnidadIncImpuestoMN( $this->getCostoUnidadIncImpuestoMN(), true );
        $this->setOrdenDetallePrecioUnidad( $this->getOrdenDetallePrecioUnidad(), true );
        $this->setOrdenDetallePrecioUnidadMN( $this->getOrdenDetallePrecioUnidadMN(), true );
        $this->setOrdenDetalleDsctoUnidad( $this->getOrdenDetalleDsctoUnidad(), true );
        $this->setOrdenDetalleDsctoUnidadMN( $this->getOrdenDetalleDsctoUnidadMN(), true );
        $this->setOrdenDetalleAfectoImpuesto( $this->getOrdenDetalleAfectoImpuesto(), true );
        $this->setOrdenDetalleImpuestoUnidad( $this->getOrdenDetalleImpuestoUnidad(), true );
        $this->setOrdenDetalleImpuestoUnidadMN( $this->getOrdenDetalleImpuestoUnidadMN(), true );
        $this->setPrecioUnidadIncImpuesto( $this->getPrecioUnidadIncImpuesto(), true );
        $this->setPrecioUnidadIncImpuestoMN( $this->getPrecioUnidadIncImpuestoMN(), true );
        $this->setOrdenDetalleCantidad( $this->getOrdenDetalleCantidad(), true );
        $this->setOrdenDetalleSubTotalVenta( $this->getOrdenDetalleSubTotalVenta(), true );
        $this->setOrdenDetalleSubTotalVentaMN( $this->getOrdenDetalleSubTotalVentaMN(), true );
        $this->setOrdenDetalleSubTotalImpuesto( $this->getOrdenDetalleSubTotalImpuesto(), true );
        $this->setOrdenDetalleSubTotalImpuestoMN( $this->getOrdenDetalleSubTotalImpuestoMN(), true );
        $this->setOrdenDetalleSubTotalNeto( $this->getOrdenDetalleSubTotalNeto(), true );
        $this->setOrdenDetalleSubTotalNetoMN( $this->getOrdenDetalleSubTotalNetoMN(), true );
        $this->setDocRefTipoCod( $this->getDocRefTipoCod(), true );
        $this->setDocRefNum( $this->getDocRefNum(), true );
        $this->setDocRefId( $this->getDocRefId(), true );
        $this->setOrdenDetalleObs( $this->getOrdenDetalleObs(), true );
        $this->setOrdenDetalleEstado( $this->getOrdenDetalleEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>