<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_RutaDetalle.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Validacion del contenido de los campos campos de la tabla TR_RutaDetalle */
abstract class BaseTR_RutaDetalleBV extends TR_RutaDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdRuta */
    public function setIdRuta( $i_IdRuta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRuta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRuta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRuta( $i_IdRuta );
        return true;
    }

    /* Valida y establece el valor del campo IdRutaLinea */
    public function setIdRutaLinea( $i_IdRutaLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRutaLinea, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRutaLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRutaLinea( $i_IdRutaLinea );
        return true;
    }

    /* Valida y establece el valor del campo RutaSecuencia */
    public function setRutaSecuencia( $i_RutaSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_RutaSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo RutaSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaSecuencia( $i_RutaSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo RutaDocDespacho */
    public function setRutaDocDespacho( $s_RutaDocDespacho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaDocDespacho, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo RutaDocDespacho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDocDespacho( $s_RutaDocDespacho );
        return true;
    }

    /* Valida y establece el valor del campo DocumentRefId */
    public function setDocumentRefId( $s_DocumentRefId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentRefId, "VARCHAR", 45, 0, false ) )
            {
                throw new Exception( "El campo DocumentRefId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentRefId( $s_DocumentRefId );
        return true;
    }

    /* Valida y establece el valor del campo RutaDetDir1 */
    public function setRutaDetDir1( $s_RutaDetDir1, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaDetDir1, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo RutaDetDir1 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDetDir1( $s_RutaDetDir1 );
        return true;
    }

    /* Valida y establece el valor del campo RutaDetDir2 */
    public function setRutaDetDir2( $s_RutaDetDir2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaDetDir2, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo RutaDetDir2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDetDir2( $s_RutaDetDir2 );
        return true;
    }

    /* Valida y establece el valor del campo RutaDetCiudad */
    public function setRutaDetCiudad( $s_RutaDetCiudad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaDetCiudad, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo RutaDetCiudad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDetCiudad( $s_RutaDetCiudad );
        return true;
    }

    /* Valida y establece el valor del campo RutaDetDpto */
    public function setRutaDetDpto( $s_RutaDetDpto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaDetDpto, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo RutaDetDpto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDetDpto( $s_RutaDetDpto );
        return true;
    }

    /* Valida y establece el valor del campo RutaDetPais */
    public function setRutaDetPais( $s_RutaDetPais, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaDetPais, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo RutaDetPais ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDetPais( $s_RutaDetPais );
        return true;
    }

    /* Valida y establece el valor del campo IdUbigeo */
    public function setIdUbigeo( $s_IdUbigeo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUbigeo, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdUbigeo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUbigeo( $s_IdUbigeo );
        return true;
    }

    /* Valida y establece el valor del campo RutaDetEstado */
    public function setRutaDetEstado( $s_RutaDetEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaDetEstado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo RutaDetEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDetEstado( $s_RutaDetEstado );
        return true;
    }

    /* Valida y establece el valor del campo RutaHoraPartida */
    public function setRutaHoraPartida( $d_RutaHoraPartida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaHoraPartida, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaHoraPartida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaHoraPartida( $d_RutaHoraPartida );
        return true;
    }

    /* Valida y establece el valor del campo RutaHoraLlegada */
    public function setRutaHoraLlegada( $d_RutaHoraLlegada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaHoraLlegada, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaHoraLlegada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaHoraLlegada( $d_RutaHoraLlegada );
        return true;
    }

    /* Valida y establece el valor del campo RutaHoraIniEntrega */
    public function setRutaHoraIniEntrega( $d_RutaHoraIniEntrega, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaHoraIniEntrega, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaHoraIniEntrega ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaHoraIniEntrega( $d_RutaHoraIniEntrega );
        return true;
    }

    /* Valida y establece el valor del campo RutaHoraFinEntrega */
    public function setRutaHoraFinEntrega( $d_RutaHoraFinEntrega, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaHoraFinEntrega, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaHoraFinEntrega ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaHoraFinEntrega( $d_RutaHoraFinEntrega );
        return true;
    }

    /* Valida y establece el valor del campo RutaHoraRegAtencion */
    public function setRutaHoraRegAtencion( $d_RutaHoraRegAtencion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaHoraRegAtencion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaHoraRegAtencion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaHoraRegAtencion( $d_RutaHoraRegAtencion );
        return true;
    }

    /* Valida y establece el valor del campo RutaDetComentario */
    public function setRutaDetComentario( $u_RutaDetComentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_RutaDetComentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaDetComentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDetComentario( $u_RutaDetComentario );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocRef */
    public function setTipoDocRef( $s_TipoDocRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocRef, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo TipoDocRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocRef( $s_TipoDocRef );
        return true;
    }

    /* Valida y establece el valor del campo SerieDocumentoRef */
    public function setSerieDocumentoRef( $s_SerieDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieDocumentoRef, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo SerieDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieDocumentoRef( $s_SerieDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumentoRef */
    public function setNumeroDocumentoRef( $s_NumeroDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumentoRef, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumentoRef( $s_NumeroDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdRuta( $this->getIdRuta(), false );
        $this->setIdRutaLinea( $this->getIdRutaLinea(), false );
        $this->setRutaSecuencia( $this->getRutaSecuencia(), true );
        $this->setRutaDocDespacho( $this->getRutaDocDespacho(), true );
        $this->setDocumentRefId( $this->getDocumentRefId(), true );
        $this->setRutaDetDir1( $this->getRutaDetDir1(), true );
        $this->setRutaDetDir2( $this->getRutaDetDir2(), true );
        $this->setRutaDetCiudad( $this->getRutaDetCiudad(), true );
        $this->setRutaDetDpto( $this->getRutaDetDpto(), true );
        $this->setRutaDetPais( $this->getRutaDetPais(), true );
        $this->setIdUbigeo( $this->getIdUbigeo(), true );
        $this->setRutaDetEstado( $this->getRutaDetEstado(), true );
        $this->setRutaHoraPartida( $this->getRutaHoraPartida(), true );
        $this->setRutaHoraLlegada( $this->getRutaHoraLlegada(), true );
        $this->setRutaHoraIniEntrega( $this->getRutaHoraIniEntrega(), true );
        $this->setRutaHoraFinEntrega( $this->getRutaHoraFinEntrega(), true );
        $this->setRutaHoraRegAtencion( $this->getRutaHoraRegAtencion(), true );
        $this->setRutaDetComentario( $this->getRutaDetComentario(), true );
        $this->setTipoDocRef( $this->getTipoDocRef(), true );
        $this->setSerieDocumentoRef( $this->getSerieDocumentoRef(), true );
        $this->setNumeroDocumentoRef( $this->getNumeroDocumentoRef(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>