<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Ruta.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Validacion del contenido de los campos campos de la tabla TR_Ruta */
abstract class BaseTR_RutaBV extends TR_RutaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdRuta */
    public function setIdRuta( $i_IdRuta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRuta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRuta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRuta( $i_IdRuta );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo RutaDocumento */
    public function setRutaDocumento( $s_RutaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo RutaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaDocumento( $s_RutaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo RutaFechaProgramada */
    public function setRutaFechaProgramada( $d_RutaFechaProgramada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaFechaProgramada, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaFechaProgramada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaFechaProgramada( $d_RutaFechaProgramada );
        return true;
    }

    /* Valida y establece el valor del campo IdTurno */
    public function setIdTurno( $i_IdTurno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTurno, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTurno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTurno( $i_IdTurno );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculo */
    public function setIdVehiculo( $i_IdVehiculo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculo( $i_IdVehiculo );
        return true;
    }

    /* Valida y establece el valor del campo IdChofer */
    public function setIdChofer( $i_IdChofer, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdChofer, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdChofer ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdChofer( $i_IdChofer );
        return true;
    }

    /* Valida y establece el valor del campo RutaFechaEmision */
    public function setRutaFechaEmision( $d_RutaFechaEmision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaFechaEmision, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaFechaEmision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaFechaEmision( $d_RutaFechaEmision );
        return true;
    }

    /* Valida y establece el valor del campo RutaFechaPartida */
    public function setRutaFechaPartida( $d_RutaFechaPartida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaFechaPartida, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaFechaPartida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaFechaPartida( $d_RutaFechaPartida );
        return true;
    }

    /* Valida y establece el valor del campo RutaFechaLlegada */
    public function setRutaFechaLlegada( $d_RutaFechaLlegada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RutaFechaLlegada, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaFechaLlegada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaFechaLlegada( $d_RutaFechaLlegada );
        return true;
    }

    /* Valida y establece el valor del campo RutaComentario */
    public function setRutaComentario( $u_RutaComentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_RutaComentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo RutaComentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaComentario( $u_RutaComentario );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdRuta( $this->getIdRuta(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setRutaDocumento( $this->getRutaDocumento(), true );
        $this->setRutaFechaProgramada( $this->getRutaFechaProgramada(), true );
        $this->setIdTurno( $this->getIdTurno(), true );
        $this->setIdVehiculo( $this->getIdVehiculo(), true );
        $this->setIdChofer( $this->getIdChofer(), true );
        $this->setRutaFechaEmision( $this->getRutaFechaEmision(), true );
        $this->setRutaFechaPartida( $this->getRutaFechaPartida(), true );
        $this->setRutaFechaLlegada( $this->getRutaFechaLlegada(), true );
        $this->setRutaComentario( $this->getRutaComentario(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>