<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Chofer.xml */
/* Generado: 2021-09-09 16:55:24 */

/* Validacion del contenido de los campos campos de la tabla TR_Chofer */
abstract class BaseTR_ChoferBV extends TR_ChoferBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdChofer */
    public function setIdChofer( $i_IdChofer, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdChofer, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdChofer ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdChofer( $i_IdChofer );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo ChoferDocumento */
    public function setChoferDocumento( $s_ChoferDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ChoferDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferDocumento( $s_ChoferDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ChoferApellidoP */
    public function setChoferApellidoP( $s_ChoferApellidoP, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferApellidoP, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ChoferApellidoP ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferApellidoP( $s_ChoferApellidoP );
        return true;
    }

    /* Valida y establece el valor del campo ChoferApellidoM */
    public function setChoferApellidoM( $s_ChoferApellidoM, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferApellidoM, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ChoferApellidoM ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferApellidoM( $s_ChoferApellidoM );
        return true;
    }

    /* Valida y establece el valor del campo ChoferNombre */
    public function setChoferNombre( $s_ChoferNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferNombre, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ChoferNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferNombre( $s_ChoferNombre );
        return true;
    }

    /* Valida y establece el valor del campo ChoferTelefono */
    public function setChoferTelefono( $s_ChoferTelefono, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferTelefono, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ChoferTelefono ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferTelefono( $s_ChoferTelefono );
        return true;
    }

    /* Valida y establece el valor del campo ChoferLicencia */
    public function setChoferLicencia( $s_ChoferLicencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferLicencia, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ChoferLicencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferLicencia( $s_ChoferLicencia );
        return true;
    }

    /* Valida y establece el valor del campo ChoferCategoria */
    public function setChoferCategoria( $s_ChoferCategoria, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferCategoria, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ChoferCategoria ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferCategoria( $s_ChoferCategoria );
        return true;
    }

    /* Valida y establece el valor del campo ChoferDireccion */
    public function setChoferDireccion( $s_ChoferDireccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferDireccion, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ChoferDireccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferDireccion( $s_ChoferDireccion );
        return true;
    }

    /* Valida y establece el valor del campo ChoferUbigeo */
    public function setChoferUbigeo( $s_ChoferUbigeo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferUbigeo, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ChoferUbigeo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferUbigeo( $s_ChoferUbigeo );
        return true;
    }

    /* Valida y establece el valor del campo ChoferAyudante */
    public function setChoferAyudante( $s_ChoferAyudante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ChoferAyudante, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ChoferAyudante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setChoferAyudante( $s_ChoferAyudante );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdChofer( $this->getIdChofer(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setChoferDocumento( $this->getChoferDocumento(), true );
        $this->setChoferApellidoP( $this->getChoferApellidoP(), true );
        $this->setChoferApellidoM( $this->getChoferApellidoM(), true );
        $this->setChoferNombre( $this->getChoferNombre(), true );
        $this->setChoferTelefono( $this->getChoferTelefono(), true );
        $this->setChoferLicencia( $this->getChoferLicencia(), true );
        $this->setChoferCategoria( $this->getChoferCategoria(), true );
        $this->setChoferDireccion( $this->getChoferDireccion(), true );
        $this->setChoferUbigeo( $this->getChoferUbigeo(), true );
        $this->setChoferAyudante( $this->getChoferAyudante(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>