<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: STE_ServicioTecnico.xml */
/* Generado: 2022-02-18 15:53:08 */

/* Validacion del contenido de los campos campos de la tabla STE_ServicioTecnico */
abstract class BaseSTE_ServicioTecnicoBV extends STE_ServicioTecnicoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdServicio */
    public function setIdServicio( $i_IdServicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdServicio, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdServicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdServicio( $i_IdServicio );
        return true;
    }

    /* Valida y establece el valor del campo TipoServicio */
    public function setTipoServicio( $i_TipoServicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TipoServicio, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo TipoServicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoServicio( $i_TipoServicio );
        return true;
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $s_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenId, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $s_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenNum */
    public function setOrdenNum( $s_OrdenNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenNum, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo OrdenNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenNum( $s_OrdenNum );
        return true;
    }

    /* Valida y establece el valor del campo ComprobanteId */
    public function setComprobanteId( $s_ComprobanteId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ComprobanteId, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ComprobanteId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComprobanteId( $s_ComprobanteId );
        return true;
    }

    /* Valida y establece el valor del campo ComprobanteNumero */
    public function setComprobanteNumero( $s_ComprobanteNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ComprobanteNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ComprobanteNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComprobanteNumero( $s_ComprobanteNumero );
        return true;
    }

    /* Valida y establece el valor del campo ComprobanteFecha */
    public function setComprobanteFecha( $d_ComprobanteFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ComprobanteFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo ComprobanteFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComprobanteFecha( $d_ComprobanteFecha );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo ClienteTipoDoc */
    public function setClienteTipoDoc( $s_ClienteTipoDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteTipoDoc, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ClienteTipoDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteTipoDoc( $s_ClienteTipoDoc );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNumeroDoc */
    public function setClienteNumeroDoc( $s_ClienteNumeroDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNumeroDoc, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ClienteNumeroDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNumeroDoc( $s_ClienteNumeroDoc );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNombre */
    public function setClienteNombre( $s_ClienteNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNombre, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo ClienteNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNombre( $s_ClienteNombre );
        return true;
    }

    /* Valida y establece el valor del campo ClienteDireccionFiscal */
    public function setClienteDireccionFiscal( $s_ClienteDireccionFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteDireccionFiscal, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ClienteDireccionFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteDireccionFiscal( $s_ClienteDireccionFiscal );
        return true;
    }

    /* Valida y establece el valor del campo ClienteTelefono */
    public function setClienteTelefono( $s_ClienteTelefono, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteTelefono, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ClienteTelefono ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteTelefono( $s_ClienteTelefono );
        return true;
    }

    /* Valida y establece el valor del campo ClienteCorreo */
    public function setClienteCorreo( $s_ClienteCorreo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteCorreo, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ClienteCorreo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteCorreo( $s_ClienteCorreo );
        return true;
    }

    /* Valida y establece el valor del campo SerieItem */
    public function setSerieItem( $s_SerieItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieItem, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo SerieItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieItem( $s_SerieItem );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo ProductoDescripcion */
    public function setProductoDescripcion( $s_ProductoDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProductoDescripcion, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ProductoDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProductoDescripcion( $s_ProductoDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo SerieExisteFlag */
    public function setSerieExisteFlag( $i_SerieExisteFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_SerieExisteFlag, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo SerieExisteFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieExisteFlag( $i_SerieExisteFlag );
        return true;
    }

    /* Valida y establece el valor del campo TipoGarantiaId */
    public function setTipoGarantiaId( $s_TipoGarantiaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoGarantiaId, "VARCHAR", 45, 0, false ) )
            {
                throw new Exception( "El campo TipoGarantiaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoGarantiaId( $s_TipoGarantiaId );
        return true;
    }

    /* Valida y establece el valor del campo GaratiaEstadoDesc */
    public function setGaratiaEstadoDesc( $s_GaratiaEstadoDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GaratiaEstadoDesc, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo GaratiaEstadoDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGaratiaEstadoDesc( $s_GaratiaEstadoDesc );
        return true;
    }

    /* Valida y establece el valor del campo CubreGarantiaFlag */
    public function setCubreGarantiaFlag( $i_CubreGarantiaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CubreGarantiaFlag, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo CubreGarantiaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCubreGarantiaFlag( $i_CubreGarantiaFlag );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 11, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo DescargoCliente */
    public function setDescargoCliente( $u_DescargoCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_DescargoCliente, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo DescargoCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescargoCliente( $u_DescargoCliente );
        return true;
    }

    /* Valida y establece el valor del campo RevisionRecepcion */
    public function setRevisionRecepcion( $u_RevisionRecepcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_RevisionRecepcion, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo RevisionRecepcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRevisionRecepcion( $u_RevisionRecepcion );
        return true;
    }

    /* Valida y establece el valor del campo PlazoEntrega */
    public function setPlazoEntrega( $i_PlazoEntrega, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_PlazoEntrega, "INT", 20, 0, false ) )
            {
                throw new Exception( "El campo PlazoEntrega ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPlazoEntrega( $i_PlazoEntrega );
        return true;
    }

    /* Valida y establece el valor del campo ComentarioRecepcion */
    public function setComentarioRecepcion( $u_ComentarioRecepcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_ComentarioRecepcion, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo ComentarioRecepcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentarioRecepcion( $u_ComentarioRecepcion );
        return true;
    }

    /* Valida y establece el valor del campo RecepcionUsuario */
    public function setRecepcionUsuario( $s_RecepcionUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RecepcionUsuario, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo RecepcionUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRecepcionUsuario( $s_RecepcionUsuario );
        return true;
    }

    /* Valida y establece el valor del campo RecepcionFecha */
    public function setRecepcionFecha( $d_RecepcionFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_RecepcionFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo RecepcionFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRecepcionFecha( $d_RecepcionFecha );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoUsuario */
    public function setDiagnosticoUsuario( $s_DiagnosticoUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DiagnosticoUsuario, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoUsuario( $s_DiagnosticoUsuario );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoFechaIni */
    public function setDiagnosticoFechaIni( $d_DiagnosticoFechaIni, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_DiagnosticoFechaIni, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoFechaIni ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoFechaIni( $d_DiagnosticoFechaIni );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoFechaFin */
    public function setDiagnosticoFechaFin( $d_DiagnosticoFechaFin, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_DiagnosticoFechaFin, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoFechaFin ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoFechaFin( $d_DiagnosticoFechaFin );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoExisteCobranzaFlag */
    public function setDiagnosticoExisteCobranzaFlag( $i_DiagnosticoExisteCobranzaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DiagnosticoExisteCobranzaFlag, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoExisteCobranzaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoExisteCobranzaFlag( $i_DiagnosticoExisteCobranzaFlag );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoMontoIncIGV */
    public function setDiagnosticoMontoIncIGV( $f_DiagnosticoMontoIncIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_DiagnosticoMontoIncIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo DiagnosticoMontoIncIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoMontoIncIGV( $f_DiagnosticoMontoIncIGV );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoCotizacionId */
    public function setDiagnosticoCotizacionId( $i_DiagnosticoCotizacionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DiagnosticoCotizacionId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoCotizacionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoCotizacionId( $i_DiagnosticoCotizacionId );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoCotizacionNum */
    public function setDiagnosticoCotizacionNum( $s_DiagnosticoCotizacionNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DiagnosticoCotizacionNum, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoCotizacionNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoCotizacionNum( $s_DiagnosticoCotizacionNum );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoComprobanteTipo */
    public function setDiagnosticoComprobanteTipo( $s_DiagnosticoComprobanteTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DiagnosticoComprobanteTipo, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoComprobanteTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoComprobanteTipo( $s_DiagnosticoComprobanteTipo );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoComprobanteNumero */
    public function setDiagnosticoComprobanteNumero( $s_DiagnosticoComprobanteNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DiagnosticoComprobanteNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoComprobanteNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoComprobanteNumero( $s_DiagnosticoComprobanteNumero );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoComprobanteFecha */
    public function setDiagnosticoComprobanteFecha( $d_DiagnosticoComprobanteFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_DiagnosticoComprobanteFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoComprobanteFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoComprobanteFecha( $d_DiagnosticoComprobanteFecha );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoComprobanteId */
    public function setDiagnosticoComprobanteId( $s_DiagnosticoComprobanteId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DiagnosticoComprobanteId, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoComprobanteId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoComprobanteId( $s_DiagnosticoComprobanteId );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoCobranzaEstado */
    public function setDiagnosticoCobranzaEstado( $s_DiagnosticoCobranzaEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DiagnosticoCobranzaEstado, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoCobranzaEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoCobranzaEstado( $s_DiagnosticoCobranzaEstado );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoCobranzaFecha */
    public function setDiagnosticoCobranzaFecha( $d_DiagnosticoCobranzaFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_DiagnosticoCobranzaFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoCobranzaFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoCobranzaFecha( $d_DiagnosticoCobranzaFecha );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoRevision */
    public function setDiagnosticoRevision( $u_DiagnosticoRevision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_DiagnosticoRevision, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoRevision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoRevision( $u_DiagnosticoRevision );
        return true;
    }

    /* Valida y establece el valor del campo DiagnosticoComentario */
    public function setDiagnosticoComentario( $u_DiagnosticoComentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_DiagnosticoComentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo DiagnosticoComentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiagnosticoComentario( $u_DiagnosticoComentario );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionAprobacionUsuario */
    public function setReparacionAprobacionUsuario( $s_ReparacionAprobacionUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReparacionAprobacionUsuario, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReparacionAprobacionUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionAprobacionUsuario( $s_ReparacionAprobacionUsuario );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionAprobacionFecha */
    public function setReparacionAprobacionFecha( $d_ReparacionAprobacionFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ReparacionAprobacionFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo ReparacionAprobacionFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionAprobacionFecha( $d_ReparacionAprobacionFecha );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionUsuario */
    public function setReparacionUsuario( $s_ReparacionUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReparacionUsuario, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReparacionUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionUsuario( $s_ReparacionUsuario );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionFechaIni */
    public function setReparacionFechaIni( $d_ReparacionFechaIni, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ReparacionFechaIni, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo ReparacionFechaIni ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionFechaIni( $d_ReparacionFechaIni );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionFechaFin */
    public function setReparacionFechaFin( $d_ReparacionFechaFin, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ReparacionFechaFin, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo ReparacionFechaFin ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionFechaFin( $d_ReparacionFechaFin );
        return true;
    }

    /* Valida y establece el valor del campo ReperacionAccionTomada */
    public function setReperacionAccionTomada( $u_ReperacionAccionTomada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_ReperacionAccionTomada, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo ReperacionAccionTomada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReperacionAccionTomada( $u_ReperacionAccionTomada );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionComentario */
    public function setReparacionComentario( $u_ReparacionComentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_ReparacionComentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo ReparacionComentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionComentario( $u_ReparacionComentario );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionPrecioTotalIGV */
    public function setReparacionPrecioTotalIGV( $f_ReparacionPrecioTotalIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ReparacionPrecioTotalIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ReparacionPrecioTotalIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionPrecioTotalIGV( $f_ReparacionPrecioTotalIGV );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionCotizacionId */
    public function setReparacionCotizacionId( $i_ReparacionCotizacionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ReparacionCotizacionId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ReparacionCotizacionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionCotizacionId( $i_ReparacionCotizacionId );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionCotizacionNum */
    public function setReparacionCotizacionNum( $s_ReparacionCotizacionNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReparacionCotizacionNum, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReparacionCotizacionNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionCotizacionNum( $s_ReparacionCotizacionNum );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionComprobanteTipo */
    public function setReparacionComprobanteTipo( $s_ReparacionComprobanteTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReparacionComprobanteTipo, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReparacionComprobanteTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionComprobanteTipo( $s_ReparacionComprobanteTipo );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionComprobanteNumero */
    public function setReparacionComprobanteNumero( $s_ReparacionComprobanteNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReparacionComprobanteNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReparacionComprobanteNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionComprobanteNumero( $s_ReparacionComprobanteNumero );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionComprobanteFecha */
    public function setReparacionComprobanteFecha( $d_ReparacionComprobanteFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ReparacionComprobanteFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo ReparacionComprobanteFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionComprobanteFecha( $d_ReparacionComprobanteFecha );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionComprobanteId */
    public function setReparacionComprobanteId( $s_ReparacionComprobanteId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReparacionComprobanteId, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReparacionComprobanteId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionComprobanteId( $s_ReparacionComprobanteId );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionCobranzaEstado */
    public function setReparacionCobranzaEstado( $s_ReparacionCobranzaEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReparacionCobranzaEstado, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReparacionCobranzaEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionCobranzaEstado( $s_ReparacionCobranzaEstado );
        return true;
    }

    /* Valida y establece el valor del campo ReparacionCobranzaFecha */
    public function setReparacionCobranzaFecha( $d_ReparacionCobranzaFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ReparacionCobranzaFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo ReparacionCobranzaFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReparacionCobranzaFecha( $d_ReparacionCobranzaFecha );
        return true;
    }

    /* Valida y establece el valor del campo EntregaUsuario */
    public function setEntregaUsuario( $s_EntregaUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EntregaUsuario, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo EntregaUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEntregaUsuario( $s_EntregaUsuario );
        return true;
    }

    /* Valida y establece el valor del campo EntregaFecha */
    public function setEntregaFecha( $d_EntregaFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_EntregaFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo EntregaFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEntregaFecha( $d_EntregaFecha );
        return true;
    }

    /* Valida y establece el valor del campo EntregaComentario */
    public function setEntregaComentario( $u_EntregaComentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_EntregaComentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo EntregaComentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEntregaComentario( $u_EntregaComentario );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioActualizacion */
    public function setUsuarioActualizacion( $s_UsuarioActualizacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioActualizacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioActualizacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioActualizacion( $s_UsuarioActualizacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaActualizacion */
    public function setFechaActualizacion( $d_FechaActualizacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaActualizacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaActualizacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaActualizacion( $d_FechaActualizacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdServicio( $this->getIdServicio(), false );
        $this->setTipoServicio( $this->getTipoServicio(), true );
        $this->setOrdenId( $this->getOrdenId(), true );
        $this->setOrdenNum( $this->getOrdenNum(), true );
        $this->setComprobanteId( $this->getComprobanteId(), true );
        $this->setComprobanteNumero( $this->getComprobanteNumero(), true );
        $this->setComprobanteFecha( $this->getComprobanteFecha(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setClienteTipoDoc( $this->getClienteTipoDoc(), true );
        $this->setClienteNumeroDoc( $this->getClienteNumeroDoc(), true );
        $this->setClienteNombre( $this->getClienteNombre(), true );
        $this->setClienteDireccionFiscal( $this->getClienteDireccionFiscal(), true );
        $this->setClienteTelefono( $this->getClienteTelefono(), true );
        $this->setClienteCorreo( $this->getClienteCorreo(), true );
        $this->setSerieItem( $this->getSerieItem(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setProductoDescripcion( $this->getProductoDescripcion(), true );
        $this->setSerieExisteFlag( $this->getSerieExisteFlag(), true );
        $this->setTipoGarantiaId( $this->getTipoGarantiaId(), true );
        $this->setGaratiaEstadoDesc( $this->getGaratiaEstadoDesc(), true );
        $this->setCubreGarantiaFlag( $this->getCubreGarantiaFlag(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setDescargoCliente( $this->getDescargoCliente(), true );
        $this->setRevisionRecepcion( $this->getRevisionRecepcion(), true );
        $this->setPlazoEntrega( $this->getPlazoEntrega(), true );
        $this->setComentarioRecepcion( $this->getComentarioRecepcion(), true );
        $this->setRecepcionUsuario( $this->getRecepcionUsuario(), true );
        $this->setRecepcionFecha( $this->getRecepcionFecha(), true );
        $this->setDiagnosticoUsuario( $this->getDiagnosticoUsuario(), true );
        $this->setDiagnosticoFechaIni( $this->getDiagnosticoFechaIni(), true );
        $this->setDiagnosticoFechaFin( $this->getDiagnosticoFechaFin(), true );
        $this->setDiagnosticoExisteCobranzaFlag( $this->getDiagnosticoExisteCobranzaFlag(), true );
        $this->setDiagnosticoMontoIncIGV( $this->getDiagnosticoMontoIncIGV(), true );
        $this->setDiagnosticoCotizacionId( $this->getDiagnosticoCotizacionId(), true );
        $this->setDiagnosticoCotizacionNum( $this->getDiagnosticoCotizacionNum(), true );
        $this->setDiagnosticoComprobanteTipo( $this->getDiagnosticoComprobanteTipo(), true );
        $this->setDiagnosticoComprobanteNumero( $this->getDiagnosticoComprobanteNumero(), true );
        $this->setDiagnosticoComprobanteFecha( $this->getDiagnosticoComprobanteFecha(), true );
        $this->setDiagnosticoComprobanteId( $this->getDiagnosticoComprobanteId(), true );
        $this->setDiagnosticoCobranzaEstado( $this->getDiagnosticoCobranzaEstado(), true );
        $this->setDiagnosticoCobranzaFecha( $this->getDiagnosticoCobranzaFecha(), true );
        $this->setDiagnosticoRevision( $this->getDiagnosticoRevision(), true );
        $this->setDiagnosticoComentario( $this->getDiagnosticoComentario(), true );
        $this->setReparacionAprobacionUsuario( $this->getReparacionAprobacionUsuario(), true );
        $this->setReparacionAprobacionFecha( $this->getReparacionAprobacionFecha(), true );
        $this->setReparacionUsuario( $this->getReparacionUsuario(), true );
        $this->setReparacionFechaIni( $this->getReparacionFechaIni(), true );
        $this->setReparacionFechaFin( $this->getReparacionFechaFin(), true );
        $this->setReperacionAccionTomada( $this->getReperacionAccionTomada(), true );
        $this->setReparacionComentario( $this->getReparacionComentario(), true );
        $this->setReparacionPrecioTotalIGV( $this->getReparacionPrecioTotalIGV(), true );
        $this->setReparacionCotizacionId( $this->getReparacionCotizacionId(), true );
        $this->setReparacionCotizacionNum( $this->getReparacionCotizacionNum(), true );
        $this->setReparacionComprobanteTipo( $this->getReparacionComprobanteTipo(), true );
        $this->setReparacionComprobanteNumero( $this->getReparacionComprobanteNumero(), true );
        $this->setReparacionComprobanteFecha( $this->getReparacionComprobanteFecha(), true );
        $this->setReparacionComprobanteId( $this->getReparacionComprobanteId(), true );
        $this->setReparacionCobranzaEstado( $this->getReparacionCobranzaEstado(), true );
        $this->setReparacionCobranzaFecha( $this->getReparacionCobranzaFecha(), true );
        $this->setEntregaUsuario( $this->getEntregaUsuario(), true );
        $this->setEntregaFecha( $this->getEntregaFecha(), true );
        $this->setEntregaComentario( $this->getEntregaComentario(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioActualizacion( $this->getUsuarioActualizacion(), true );
        $this->setFechaActualizacion( $this->getFechaActualizacion(), true );
        return true;
    }
}
?>