<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_Serie.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Validacion del contenido de los campos campos de la tabla SR_Serie */
abstract class BaseSR_SerieBV extends SR_SerieBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo SerieId */
    public function setSerieId( $i_SerieId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_SerieId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo SerieId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieId( $i_SerieId );
        return true;
    }

    /* Valida y establece el valor del campo MovimientoId */
    public function setMovimientoId( $i_MovimientoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MovimientoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MovimientoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMovimientoId( $i_MovimientoId );
        return true;
    }

    /* Valida y establece el valor del campo ProductoId */
    public function setProductoId( $s_ProductoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProductoId, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ProductoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProductoId( $s_ProductoId );
        return true;
    }

    /* Valida y establece el valor del campo SerieNumero */
    public function setSerieNumero( $s_SerieNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo SerieNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieNumero( $s_SerieNumero );
        return true;
    }

    /* Valida y establece el valor del campo Almacen */
    public function setAlmacen( $s_Almacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Almacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Almacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacen( $s_Almacen );
        return true;
    }

    /* Valida y establece el valor del campo UltimaOperacion */
    public function setUltimaOperacion( $s_UltimaOperacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UltimaOperacion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo UltimaOperacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUltimaOperacion( $s_UltimaOperacion );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipo */
    public function setReferenciaTipo( $s_ReferenciaTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipo, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipo( $s_ReferenciaTipo );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumero */
    public function setReferenciaNumero( $s_ReferenciaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumero, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumero( $s_ReferenciaNumero );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $u_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Comentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $u_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioRegistro */
    public function setUsuarioRegistro( $s_UsuarioRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioRegistro, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioRegistro( $s_UsuarioRegistro );
        return true;
    }

    /* Valida y establece el valor del campo FechaRegistro */
    public function setFechaRegistro( $d_FechaRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRegistro, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRegistro( $d_FechaRegistro );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setSerieId( $this->getSerieId(), false );
        $this->setMovimientoId( $this->getMovimientoId(), true );
        $this->setProductoId( $this->getProductoId(), true );
        $this->setSerieNumero( $this->getSerieNumero(), true );
        $this->setAlmacen( $this->getAlmacen(), true );
        $this->setUltimaOperacion( $this->getUltimaOperacion(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setReferenciaTipo( $this->getReferenciaTipo(), true );
        $this->setReferenciaNumero( $this->getReferenciaNumero(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setUsuarioRegistro( $this->getUsuarioRegistro(), true );
        $this->setFechaRegistro( $this->getFechaRegistro(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>