<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_GuiaRemisionDet.xml */
/* Generado: 2021-05-03 06:53:23 */

/* Validacion del contenido de los campos campos de la tabla SR_GuiaRemisionDet */
abstract class BaseSR_GuiaRemisionDetBV extends SR_GuiaRemisionDetBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo GuiaRemisionDetId */
    public function setGuiaRemisionDetId( $i_GuiaRemisionDetId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_GuiaRemisionDetId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo GuiaRemisionDetId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGuiaRemisionDetId( $i_GuiaRemisionDetId );
        return true;
    }

    /* Valida y establece el valor del campo GuiaRemisionId */
    public function setGuiaRemisionId( $s_GuiaRemisionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GuiaRemisionId, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo GuiaRemisionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGuiaRemisionId( $s_GuiaRemisionId );
        return true;
    }

    /* Valida y establece el valor del campo MovimientoId */
    public function setMovimientoId( $i_MovimientoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MovimientoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MovimientoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMovimientoId( $i_MovimientoId );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $s_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Secuencia, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $s_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo ProFinalId */
    public function setProFinalId( $i_ProFinalId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ProFinalId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ProFinalId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProFinalId( $i_ProFinalId );
        return true;
    }

    /* Valida y establece el valor del campo ProFinalDetId */
    public function setProFinalDetId( $i_ProFinalDetId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ProFinalDetId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ProFinalDetId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProFinalDetId( $i_ProFinalDetId );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $i_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $i_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 12, 2, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo PesoUnitario */
    public function setPesoUnitario( $f_PesoUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PesoUnitario, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo PesoUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPesoUnitario( $f_PesoUnitario );
        return true;
    }

    /* Valida y establece el valor del campo PesoTotal */
    public function setPesoTotal( $f_PesoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PesoTotal, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo PesoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPesoTotal( $f_PesoTotal );
        return true;
    }

    /* Valida y establece el valor del campo CantidadPendienteDevolucion */
    public function setCantidadPendienteDevolucion( $f_CantidadPendienteDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadPendienteDevolucion, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadPendienteDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadPendienteDevolucion( $f_CantidadPendienteDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo DiasMinimoAlquiler */
    public function setDiasMinimoAlquiler( $i_DiasMinimoAlquiler, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DiasMinimoAlquiler, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DiasMinimoAlquiler ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiasMinimoAlquiler( $i_DiasMinimoAlquiler );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioAlquilerLocal */
    public function setPrecioUnitarioAlquilerLocal( $f_PrecioUnitarioAlquilerLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioAlquilerLocal, "DECIMAL", 14, 4, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioAlquilerLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioAlquilerLocal( $f_PrecioUnitarioAlquilerLocal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioAlquilerDolares */
    public function setPrecioUnitarioAlquilerDolares( $f_PrecioUnitarioAlquilerDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioAlquilerDolares, "DECIMAL", 14, 4, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioAlquilerDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioAlquilerDolares( $f_PrecioUnitarioAlquilerDolares );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioVentaLocal */
    public function setPrecioUnitarioVentaLocal( $f_PrecioUnitarioVentaLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioVentaLocal, "DECIMAL", 14, 4, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioVentaLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioVentaLocal( $f_PrecioUnitarioVentaLocal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioVentaDolares */
    public function setPrecioUnitarioVentaDolares( $f_PrecioUnitarioVentaDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioVentaDolares, "DECIMAL", 14, 4, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioVentaDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioVentaDolares( $f_PrecioUnitarioVentaDolares );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setGuiaRemisionDetId( $this->getGuiaRemisionDetId(), false );
        $this->setGuiaRemisionId( $this->getGuiaRemisionId(), true );
        $this->setMovimientoId( $this->getMovimientoId(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setSecuencia( $this->getSecuencia(), true );
        $this->setProFinalId( $this->getProFinalId(), true );
        $this->setProFinalDetId( $this->getProFinalDetId(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setPesoUnitario( $this->getPesoUnitario(), true );
        $this->setPesoTotal( $this->getPesoTotal(), true );
        $this->setCantidadPendienteDevolucion( $this->getCantidadPendienteDevolucion(), true );
        $this->setDiasMinimoAlquiler( $this->getDiasMinimoAlquiler(), true );
        $this->setPrecioUnitarioAlquilerLocal( $this->getPrecioUnitarioAlquilerLocal(), true );
        $this->setPrecioUnitarioAlquilerDolares( $this->getPrecioUnitarioAlquilerDolares(), true );
        $this->setPrecioUnitarioVentaLocal( $this->getPrecioUnitarioVentaLocal(), true );
        $this->setPrecioUnitarioVentaDolares( $this->getPrecioUnitarioVentaDolares(), true );
        return true;
    }
}
?>