<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionTransaccion.xml */
/* Generado: 2021-05-13 05:56:55 */

/* Validacion del contenido de los campos campos de la tabla SR_DevolucionTransaccion */
abstract class BaseSR_DevolucionTransaccionBV extends SR_DevolucionTransaccionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo DevolucionTransId */
    public function setDevolucionTransId( $i_DevolucionTransId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DevolucionTransId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DevolucionTransId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDevolucionTransId( $i_DevolucionTransId );
        return true;
    }

    /* Valida y establece el valor del campo DevolucionCabId */
    public function setDevolucionCabId( $i_DevolucionCabId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DevolucionCabId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DevolucionCabId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDevolucionCabId( $i_DevolucionCabId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $i_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $i_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo EstadoDevolucionId */
    public function setEstadoDevolucionId( $s_EstadoDevolucionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDevolucionId, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EstadoDevolucionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDevolucionId( $s_EstadoDevolucionId );
        return true;
    }

    /* Valida y establece el valor del campo Tipo */
    public function setTipo( $s_Tipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Tipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo( $s_Tipo );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacenOrigen */
    public function setIdAlmacenOrigen( $s_IdAlmacenOrigen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacenOrigen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacenOrigen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacenOrigen( $s_IdAlmacenOrigen );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacenDestino */
    public function setIdAlmacenDestino( $s_IdAlmacenDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacenDestino, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacenDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacenDestino( $s_IdAlmacenDestino );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumento */
    public function setIdNumeroDocumento( $s_IdNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumento( $s_IdNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccion */
    public function setIdTransaccion( $s_IdTransaccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccion, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccion( $s_IdTransaccion );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumentoFiscal */
    public function setTipoDocumentoFiscal( $s_TipoDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumentoFiscal, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumentoFiscal( $s_TipoDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo SerieDocumentoFiscal */
    public function setSerieDocumentoFiscal( $s_SerieDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieDocumentoFiscal, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo SerieDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieDocumentoFiscal( $s_SerieDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumentoFiscal */
    public function setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumentoFiscal, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setDevolucionTransId( $this->getDevolucionTransId(), false );
        $this->setDevolucionCabId( $this->getDevolucionCabId(), true );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setOrdenId( $this->getOrdenId(), true );
        $this->setEstadoDevolucionId( $this->getEstadoDevolucionId(), true );
        $this->setTipo( $this->getTipo(), true );
        $this->setIdAlmacenOrigen( $this->getIdAlmacenOrigen(), true );
        $this->setIdAlmacenDestino( $this->getIdAlmacenDestino(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setIdNumeroDocumento( $this->getIdNumeroDocumento(), true );
        $this->setIdTransaccion( $this->getIdTransaccion(), true );
        $this->setTipoDocumentoFiscal( $this->getTipoDocumentoFiscal(), true );
        $this->setSerieDocumentoFiscal( $this->getSerieDocumentoFiscal(), true );
        $this->setNumeroDocumentoFiscal( $this->getNumeroDocumentoFiscal(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        return true;
    }
}
?>