<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionDetCorte.xml */
/* Generado: 2021-06-25 07:20:20 */

/* Validacion del contenido de los campos campos de la tabla SR_DevolucionDetCorte */
abstract class BaseSR_DevolucionDetCorteBV extends SR_DevolucionDetCorteBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo DevolDetCorteId */
    public function setDevolDetCorteId( $i_DevolDetCorteId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DevolDetCorteId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DevolDetCorteId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDevolDetCorteId( $i_DevolDetCorteId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo EstadoDevolucionId */
    public function setEstadoDevolucionId( $s_EstadoDevolucionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDevolucionId, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EstadoDevolucionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDevolucionId( $s_EstadoDevolucionId );
        return true;
    }

    /* Valida y establece el valor del campo GrupoId */
    public function setGrupoId( $s_GrupoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GrupoId, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo GrupoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGrupoId( $s_GrupoId );
        return true;
    }

    /* Valida y establece el valor del campo FechaIni */
    public function setFechaIni( $d_FechaIni, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaIni, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaIni ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaIni( $d_FechaIni );
        return true;
    }

    /* Valida y establece el valor del campo Tipo */
    public function setTipo( $s_Tipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo Tipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo( $s_Tipo );
        return true;
    }

    /* Valida y establece el valor del campo EstadoDesc */
    public function setEstadoDesc( $s_EstadoDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDesc, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo EstadoDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDesc( $s_EstadoDesc );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo Documento */
    public function setDocumento( $s_Documento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Documento, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo Documento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumento( $s_Documento );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionItem */
    public function setDescripcionItem( $s_DescripcionItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionItem, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo DescripcionItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionItem( $s_DescripcionItem );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo FechaFin */
    public function setFechaFin( $d_FechaFin, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFin, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFin ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFin( $d_FechaFin );
        return true;
    }

    /* Valida y establece el valor del campo FechaCorte */
    public function setFechaCorte( $d_FechaCorte, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCorte, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCorte ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCorte( $d_FechaCorte );
        return true;
    }

    /* Valida y establece el valor del campo Dias */
    public function setDias( $i_Dias, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Dias, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Dias ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDias( $i_Dias );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setDevolDetCorteId( $this->getDevolDetCorteId(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setEstadoDevolucionId( $this->getEstadoDevolucionId(), true );
        $this->setGrupoId( $this->getGrupoId(), true );
        $this->setFechaIni( $this->getFechaIni(), true );
        $this->setTipo( $this->getTipo(), true );
        $this->setEstadoDesc( $this->getEstadoDesc(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setDocumento( $this->getDocumento(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setDescripcionItem( $this->getDescripcionItem(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setFechaFin( $this->getFechaFin(), true );
        $this->setFechaCorte( $this->getFechaCorte(), true );
        $this->setDias( $this->getDias(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>