<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionCabecera.xml */
/* Generado: 2021-06-25 10:06:37 */

/* Validacion del contenido de los campos campos de la tabla SR_DevolucionCabecera */
abstract class BaseSR_DevolucionCabeceraBV extends SR_DevolucionCabeceraBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo DevolucionCabId */
    public function setDevolucionCabId( $i_DevolucionCabId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DevolucionCabId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DevolucionCabId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDevolucionCabId( $i_DevolucionCabId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $i_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $i_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo ParentId */
    public function setParentId( $i_ParentId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ParentId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ParentId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setParentId( $i_ParentId );
        return true;
    }

    /* Valida y establece el valor del campo Tipo */
    public function setTipo( $s_Tipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Tipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo( $s_Tipo );
        return true;
    }

    /* Valida y establece el valor del campo TransGuiaSerie */
    public function setTransGuiaSerie( $s_TransGuiaSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransGuiaSerie, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TransGuiaSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransGuiaSerie( $s_TransGuiaSerie );
        return true;
    }

    /* Valida y establece el valor del campo TransGuiaNumero */
    public function setTransGuiaNumero( $s_TransGuiaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransGuiaNumero, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo TransGuiaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransGuiaNumero( $s_TransGuiaNumero );
        return true;
    }

    /* Valida y establece el valor del campo ObraGuiaSerie */
    public function setObraGuiaSerie( $s_ObraGuiaSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ObraGuiaSerie, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo ObraGuiaSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObraGuiaSerie( $s_ObraGuiaSerie );
        return true;
    }

    /* Valida y establece el valor del campo ObraGuiaNumero */
    public function setObraGuiaNumero( $s_ObraGuiaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ObraGuiaNumero, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ObraGuiaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObraGuiaNumero( $s_ObraGuiaNumero );
        return true;
    }

    /* Valida y establece el valor del campo Observaciones */
    public function setObservaciones( $s_Observaciones, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Observaciones, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo Observaciones ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObservaciones( $s_Observaciones );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicioAlq */
    public function setFechaInicioAlq( $d_FechaInicioAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicioAlq, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicioAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicioAlq( $d_FechaInicioAlq );
        return true;
    }

    /* Valida y establece el valor del campo FechaDevolucion */
    public function setFechaDevolucion( $d_FechaDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDevolucion, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDevolucion( $d_FechaDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo EstadoCorte */
    public function setEstadoCorte( $s_EstadoCorte, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoCorte, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EstadoCorte ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoCorte( $s_EstadoCorte );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setDevolucionCabId( $this->getDevolucionCabId(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setOrdenId( $this->getOrdenId(), true );
        $this->setParentId( $this->getParentId(), true );
        $this->setTipo( $this->getTipo(), true );
        $this->setTransGuiaSerie( $this->getTransGuiaSerie(), true );
        $this->setTransGuiaNumero( $this->getTransGuiaNumero(), true );
        $this->setObraGuiaSerie( $this->getObraGuiaSerie(), true );
        $this->setObraGuiaNumero( $this->getObraGuiaNumero(), true );
        $this->setObservaciones( $this->getObservaciones(), true );
        $this->setFechaInicioAlq( $this->getFechaInicioAlq(), true );
        $this->setFechaDevolucion( $this->getFechaDevolucion(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setEstadoCorte( $this->getEstadoCorte(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>