<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SRV_UbicacionEstado.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Validacion del contenido de los campos campos de la tabla SRV_UbicacionEstado */
abstract class BaseSRV_UbicacionEstadoBV extends SRV_UbicacionEstadoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdUbicacion */
    public function setIdUbicacion( $i_IdUbicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUbicacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUbicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUbicacion( $i_IdUbicacion );
        return true;
    }

    /* Valida y establece el valor del campo IdEstados */
    public function setIdEstados( $i_IdEstados, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdEstados, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdEstados ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdEstados( $i_IdEstados );
        return true;
    }

    /* Valida y establece el valor del campo EstadoNombre */
    public function setEstadoNombre( $s_EstadoNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoNombre, "VARCHAR", 140, 0, false ) )
            {
                throw new Exception( "El campo EstadoNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoNombre( $s_EstadoNombre );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdUbicacion( $this->getIdUbicacion(), false );
        $this->setIdEstados( $this->getIdEstados(), true );
        $this->setEstadoNombre( $this->getEstadoNombre(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        return true;
    }
}
?>