<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SRV_UbicacionClienteH.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Validacion del contenido de los campos campos de la tabla SRV_UbicacionClienteH */
abstract class BaseSRV_UbicacionClienteHBV extends SRV_UbicacionClienteHBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdUbicacionClienteH */
    public function setIdUbicacionClienteH( $i_IdUbicacionClienteH, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUbicacionClienteH, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUbicacionClienteH ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUbicacionClienteH( $i_IdUbicacionClienteH );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdUbicacion */
    public function setIdUbicacion( $i_IdUbicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUbicacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUbicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUbicacion( $i_IdUbicacion );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoCod */
    public function setDocumentoCod( $s_DocumentoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoCod, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo DocumentoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoCod( $s_DocumentoCod );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoSerie */
    public function setDocumentoSerie( $s_DocumentoSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoSerie, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo DocumentoSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoSerie( $s_DocumentoSerie );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoNumero */
    public function setDocumentoNumero( $s_DocumentoNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoNumero, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo DocumentoNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoNumero( $s_DocumentoNumero );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumentoRef */
    public function setNumeroDocumentoRef( $s_NumeroDocumentoRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumentoRef, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumentoRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumentoRef( $s_NumeroDocumentoRef );
        return true;
    }

    /* Valida y establece el valor del campo Periodo */
    public function setPeriodo( $s_Periodo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Periodo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Periodo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodo( $s_Periodo );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumento */
    public function setFechaDocumento( $d_FechaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumento( $d_FechaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo FechaHoraDocumento */
    public function setFechaHoraDocumento( $d_FechaHoraDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaHoraDocumento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaHoraDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaHoraDocumento( $d_FechaHoraDocumento );
        return true;
    }

    /* Valida y establece el valor del campo HoraUbicacion */
    public function setHoraUbicacion( $i_HoraUbicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_HoraUbicacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo HoraUbicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setHoraUbicacion( $i_HoraUbicacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaHoraSalida */
    public function setFechaHoraSalida( $d_FechaHoraSalida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaHoraSalida, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaHoraSalida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaHoraSalida( $d_FechaHoraSalida );
        return true;
    }

    /* Valida y establece el valor del campo ToleranciaUbicacion */
    public function setToleranciaUbicacion( $i_ToleranciaUbicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ToleranciaUbicacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ToleranciaUbicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setToleranciaUbicacion( $i_ToleranciaUbicacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaHoraSalidaReal */
    public function setFechaHoraSalidaReal( $d_FechaHoraSalidaReal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaHoraSalidaReal, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaHoraSalidaReal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaHoraSalidaReal( $d_FechaHoraSalidaReal );
        return true;
    }

    /* Valida y establece el valor del campo MinutosExtra */
    public function setMinutosExtra( $f_MinutosExtra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MinutosExtra, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MinutosExtra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMinutosExtra( $f_MinutosExtra );
        return true;
    }

    /* Valida y establece el valor del campo MinutosExtraMonto */
    public function setMinutosExtraMonto( $f_MinutosExtraMonto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MinutosExtraMonto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MinutosExtraMonto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMinutosExtraMonto( $f_MinutosExtraMonto );
        return true;
    }

    /* Valida y establece el valor del campo IdCliente */
    public function setIdCliente( $i_IdCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCliente, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCliente( $i_IdCliente );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocCliente */
    public function setTipoDocCliente( $s_TipoDocCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocCliente, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo TipoDocCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocCliente( $s_TipoDocCliente );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocuCliente */
    public function setNumeroDocuCliente( $s_NumeroDocuCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocuCliente, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocuCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocuCliente( $s_NumeroDocuCliente );
        return true;
    }

    /* Valida y establece el valor del campo NombreCliente */
    public function setNombreCliente( $s_NombreCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreCliente, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo NombreCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreCliente( $s_NombreCliente );
        return true;
    }

    /* Valida y establece el valor del campo DireccionCliente */
    public function setDireccionCliente( $s_DireccionCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DireccionCliente, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo DireccionCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccionCliente( $s_DireccionCliente );
        return true;
    }

    /* Valida y establece el valor del campo IdItemTarifa */
    public function setIdItemTarifa( $s_IdItemTarifa, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemTarifa, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItemTarifa ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemTarifa( $s_IdItemTarifa );
        return true;
    }

    /* Valida y establece el valor del campo PrecioTarifa */
    public function setPrecioTarifa( $f_PrecioTarifa, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioTarifa, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioTarifa ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioTarifa( $f_PrecioTarifa );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo EstadoProceso */
    public function setEstadoProceso( $s_EstadoProceso, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoProceso, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EstadoProceso ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoProceso( $s_EstadoProceso );
        return true;
    }

    /* Valida y establece el valor del campo MostrarAlertaFlag */
    public function setMostrarAlertaFlag( $i_MostrarAlertaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MostrarAlertaFlag, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo MostrarAlertaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMostrarAlertaFlag( $i_MostrarAlertaFlag );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdUbicacionClienteH( $this->getIdUbicacionClienteH(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdUbicacion( $this->getIdUbicacion(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setDocumentoCod( $this->getDocumentoCod(), true );
        $this->setDocumentoSerie( $this->getDocumentoSerie(), true );
        $this->setDocumentoNumero( $this->getDocumentoNumero(), true );
        $this->setNumeroDocumentoRef( $this->getNumeroDocumentoRef(), true );
        $this->setPeriodo( $this->getPeriodo(), true );
        $this->setFechaDocumento( $this->getFechaDocumento(), true );
        $this->setFechaHoraDocumento( $this->getFechaHoraDocumento(), true );
        $this->setHoraUbicacion( $this->getHoraUbicacion(), true );
        $this->setFechaHoraSalida( $this->getFechaHoraSalida(), true );
        $this->setToleranciaUbicacion( $this->getToleranciaUbicacion(), true );
        $this->setFechaHoraSalidaReal( $this->getFechaHoraSalidaReal(), true );
        $this->setMinutosExtra( $this->getMinutosExtra(), true );
        $this->setMinutosExtraMonto( $this->getMinutosExtraMonto(), true );
        $this->setIdCliente( $this->getIdCliente(), true );
        $this->setTipoDocCliente( $this->getTipoDocCliente(), true );
        $this->setNumeroDocuCliente( $this->getNumeroDocuCliente(), true );
        $this->setNombreCliente( $this->getNombreCliente(), true );
        $this->setDireccionCliente( $this->getDireccionCliente(), true );
        $this->setIdItemTarifa( $this->getIdItemTarifa(), true );
        $this->setPrecioTarifa( $this->getPrecioTarifa(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setEstadoProceso( $this->getEstadoProceso(), true );
        $this->setMostrarAlertaFlag( $this->getMostrarAlertaFlag(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>