<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Rol.xml */
/* Generado: 2021-09-21 03:37:38 */

/* Validacion del contenido de los campos campos de la tabla SEG_Rol */
abstract class BaseSEG_RolBV extends SEG_RolBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdRol */
    public function setIdRol( $s_IdRol, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdRol, "VARCHAR", 16, 0, false ) )
            {
                throw new Exception( "El campo IdRol ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRol( $s_IdRol );
        return true;
    }

    /* Valida y establece el valor del campo RolDescripcion */
    public function setRolDescripcion( $s_RolDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RolDescripcion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo RolDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRolDescripcion( $s_RolDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo IdTareaInicio */
    public function setIdTareaInicio( $s_IdTareaInicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTareaInicio, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo IdTareaInicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTareaInicio( $s_IdTareaInicio );
        return true;
    }

    /* Valida y establece el valor del campo AccesoGlobal */
    public function setAccesoGlobal( $s_AccesoGlobal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AccesoGlobal, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AccesoGlobal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAccesoGlobal( $s_AccesoGlobal );
        return true;
    }

    /* Valida y establece el valor del campo EsAdministrador */
    public function setEsAdministrador( $s_EsAdministrador, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsAdministrador, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EsAdministrador ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsAdministrador( $s_EsAdministrador );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdRol( $this->getIdRol(), false );
        $this->setRolDescripcion( $this->getRolDescripcion(), true );
        $this->setIdTareaInicio( $this->getIdTareaInicio(), true );
        $this->setAccesoGlobal( $this->getAccesoGlobal(), true );
        $this->setEsAdministrador( $this->getEsAdministrador(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>