<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_NavBoton.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Validacion del contenido de los campos campos de la tabla SEG_NavBoton */
abstract class BaseSEG_NavBotonBV extends SEG_NavBotonBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdNavegation */
    public function setIdNavegation( $s_IdNavegation, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNavegation, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo IdNavegation ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNavegation( $s_IdNavegation );
        return true;
    }

    /* Valida y establece el valor del campo IdTareaHijo */
    public function setIdTareaHijo( $s_IdTareaHijo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTareaHijo, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo IdTareaHijo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTareaHijo( $s_IdTareaHijo );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $i_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Secuencia, "TINYINT", 3, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $i_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionBoton */
    public function setDescripcionBoton( $s_DescripcionBoton, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionBoton, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo DescripcionBoton ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionBoton( $s_DescripcionBoton );
        return true;
    }

    /* Valida y establece el valor del campo bar_type */
    public function setBar_type( $s_Bar_type, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Bar_type, "CHAR", 9, 0, false ) )
            {
                throw new Exception( "El campo bar_type ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setBar_type( $s_Bar_type );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdNavegation( $this->getIdNavegation(), false );
        $this->setIdTareaHijo( $this->getIdTareaHijo(), false );
        $this->setSecuencia( $this->getSecuencia(), true );
        $this->setDescripcionBoton( $this->getDescripcionBoton(), true );
        $this->setBar_type( $this->getBar_type(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>