<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: RegistroHistorial.xml */
/* Generado: 2021-11-29 22:17:00 */

/* Validacion del contenido de los campos campos de la tabla RegistroHistorial */
abstract class BaseRegistroHistorialBV extends RegistroHistorialBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdLog */
    public function setIdLog( $i_IdLog, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdLog, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdLog ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLog( $i_IdLog );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo BaseDatos */
    public function setBaseDatos( $s_BaseDatos, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_BaseDatos, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo BaseDatos ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setBaseDatos( $s_BaseDatos );
        return true;
    }

    /* Valida y establece el valor del campo Tabla */
    public function setTabla( $s_Tabla, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tabla, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo Tabla ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTabla( $s_Tabla );
        return true;
    }

    /* Valida y establece el valor del campo IdFecha */
    public function setIdFecha( $d_IdFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_IdFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo IdFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdFecha( $d_IdFecha );
        return true;
    }

    /* Valida y establece el valor del campo IdDocumento */
    public function setIdDocumento( $s_IdDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdDocumento, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo IdDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDocumento( $s_IdDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdCampo */
    public function setIdCampo( $s_IdCampo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdCampo, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo IdCampo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCampo( $s_IdCampo );
        return true;
    }

    /* Valida y establece el valor del campo CampoValor */
    public function setCampoValor( $s_CampoValor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CampoValor, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo CampoValor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCampoValor( $s_CampoValor );
        return true;
    }

    /* Valida y establece el valor del campo CampoDescripcion */
    public function setCampoDescripcion( $s_CampoDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CampoDescripcion, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo CampoDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCampoDescripcion( $s_CampoDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo Modulo */
    public function setModulo( $s_Modulo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Modulo, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo Modulo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setModulo( $s_Modulo );
        return true;
    }

    /* Valida y establece el valor del campo IP */
    public function setIP( $s_IP, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IP, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IP ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIP( $s_IP );
        return true;
    }

    /* Valida y establece el valor del campo ValorAnterior */
    public function setValorAnterior( $s_ValorAnterior, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ValorAnterior, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ValorAnterior ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValorAnterior( $s_ValorAnterior );
        return true;
    }

    /* Valida y establece el valor del campo ValorNuevo */
    public function setValorNuevo( $s_ValorNuevo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ValorNuevo, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ValorNuevo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValorNuevo( $s_ValorNuevo );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdLog( $this->getIdLog(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setBaseDatos( $this->getBaseDatos(), true );
        $this->setTabla( $this->getTabla(), true );
        $this->setIdFecha( $this->getIdFecha(), true );
        $this->setIdDocumento( $this->getIdDocumento(), true );
        $this->setIdCampo( $this->getIdCampo(), true );
        $this->setCampoValor( $this->getCampoValor(), true );
        $this->setCampoDescripcion( $this->getCampoDescripcion(), true );
        $this->setModulo( $this->getModulo(), true );
        $this->setIP( $this->getIP(), true );
        $this->setValorAnterior( $this->getValorAnterior(), true );
        $this->setValorNuevo( $this->getValorNuevo(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>