<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoAfectacionIGV.xml */
/* Generado: 2022-01-20 22:55:24 */

/* Validacion del contenido de los campos campos de la tabla MST_TipoAfectacionIGV */
abstract class BaseMST_TipoAfectacionIGVBV extends MST_TipoAfectacionIGVBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo TipoIgvId */
    public function setTipoIgvId( $i_TipoIgvId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TipoIgvId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TipoIgvId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoIgvId( $i_TipoIgvId );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo CodigoProv */
    public function setCodigoProv( $s_CodigoProv, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoProv, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo CodigoProv ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoProv( $s_CodigoProv );
        return true;
    }

    /* Valida y establece el valor del campo CodigoTributo */
    public function setCodigoTributo( $s_CodigoTributo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoTributo, "VARCHAR", 45, 0, false ) )
            {
                throw new Exception( "El campo CodigoTributo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoTributo( $s_CodigoTributo );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaRegistro */
    public function setFechaRegistro( $d_FechaRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRegistro, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRegistro( $d_FechaRegistro );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setTipoIgvId( $this->getTipoIgvId(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setCodigoProv( $this->getCodigoProv(), true );
        $this->setCodigoTributo( $this->getCodigoTributo(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaRegistro( $this->getFechaRegistro(), true );
        return true;
    }
}
?>