<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_StockReposicionDetalleLog.xml */
/* Generado: 2020-08-18 04:21:28 */

/* Validacion del contenido de los campos campos de la tabla MST_StockReposicionDetalleLog */
abstract class BaseMST_StockReposicionDetalleLogBV extends MST_StockReposicionDetalleLogBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdSRDLog */
    public function setIdSRDLog( $i_IdSRDLog, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSRDLog, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSRDLog ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSRDLog( $i_IdSRDLog );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo StockMinimo */
    public function setStockMinimo( $f_StockMinimo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockMinimo, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo StockMinimo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMinimo( $f_StockMinimo );
        return true;
    }

    /* Valida y establece el valor del campo StockMaximo */
    public function setStockMaximo( $f_StockMaximo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockMaximo, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo StockMaximo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMaximo( $f_StockMaximo );
        return true;
    }

    /* Valida y establece el valor del campo StockActual */
    public function setStockActual( $f_StockActual, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockActual, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo StockActual ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockActual( $f_StockActual );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificcion */
    public function setUsuarioModificcion( $s_UsuarioModificcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificcion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificcion( $s_UsuarioModificcion );
        return true;
    }

    /* Valida y establece el valor del campo FechaLog */
    public function setFechaLog( $d_FechaLog, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaLog, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaLog ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaLog( $d_FechaLog );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioLog */
    public function setUsuarioLog( $s_UsuarioLog, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioLog, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioLog ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioLog( $s_UsuarioLog );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdSRDLog( $this->getIdSRDLog(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setStockMinimo( $this->getStockMinimo(), true );
        $this->setStockMaximo( $this->getStockMaximo(), true );
        $this->setStockActual( $this->getStockActual(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificcion( $this->getUsuarioModificcion(), true );
        $this->setFechaLog( $this->getFechaLog(), true );
        $this->setUsuarioLog( $this->getUsuarioLog(), true );
        return true;
    }
}
?>