<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_RelacionReferenciaProducto.xml */
/* Generado: 2024-08-07 06:49:08 */

/* Validacion del contenido de los campos campos de la tabla MST_RelacionReferenciaProducto */
abstract class BaseMST_RelacionReferenciaProductoBV extends MST_RelacionReferenciaProductoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdReleacion */
    public function setIdReleacion( $i_IdReleacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdReleacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdReleacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdReleacion( $i_IdReleacion );
        return true;
    }

    /* Valida y establece el valor del campo IdReferencia */
    public function setIdReferencia( $i_IdReferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdReferencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdReferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdReferencia( $i_IdReferencia );
        return true;
    }

    /* Valida y establece el valor del campo IdProveedor */
    public function setIdProveedor( $i_IdProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProveedor, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProveedor( $i_IdProveedor );
        return true;
    }

    /* Valida y establece el valor del campo IdColor */
    public function setIdColor( $i_IdColor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdColor, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdColor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdColor( $i_IdColor );
        return true;
    }

    /* Valida y establece el valor del campo IdCatTalla */
    public function setIdCatTalla( $i_IdCatTalla, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCatTalla, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCatTalla ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCatTalla( $i_IdCatTalla );
        return true;
    }

    /* Valida y establece el valor del campo IdTalla */
    public function setIdTalla( $i_IdTalla, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTalla, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTalla ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTalla( $i_IdTalla );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdReleacion( $this->getIdReleacion(), false );
        $this->setIdReferencia( $this->getIdReferencia(), true );
        $this->setIdProveedor( $this->getIdProveedor(), true );
        $this->setIdColor( $this->getIdColor(), true );
        $this->setIdCatTalla( $this->getIdCatTalla(), true );
        $this->setIdTalla( $this->getIdTalla(), true );
        $this->setIdItem( $this->getIdItem(), true );
        return true;
    }
}
?>