<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_PersonaMast.xml */
/* Generado: 2021-10-06 07:34:51 */

/* Validacion del contenido de los campos campos de la tabla MST_PersonaMast */
abstract class BaseMST_PersonaMastBV extends MST_PersonaMastBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo ApellidoPaterno */
    public function setApellidoPaterno( $s_ApellidoPaterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ApellidoPaterno, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ApellidoPaterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setApellidoPaterno( $s_ApellidoPaterno );
        return true;
    }

    /* Valida y establece el valor del campo ApellidoMaterno */
    public function setApellidoMaterno( $s_ApellidoMaterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ApellidoMaterno, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo ApellidoMaterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setApellidoMaterno( $s_ApellidoMaterno );
        return true;
    }

    /* Valida y establece el valor del campo Nombres */
    public function setNombres( $s_Nombres, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Nombres, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo Nombres ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombres( $s_Nombres );
        return true;
    }

    /* Valida y establece el valor del campo NombreCompleto */
    public function setNombreCompleto( $s_NombreCompleto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreCompleto, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo NombreCompleto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreCompleto( $s_NombreCompleto );
        return true;
    }

    /* Valida y establece el valor del campo NombreComercial */
    public function setNombreComercial( $s_NombreComercial, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreComercial, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo NombreComercial ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreComercial( $s_NombreComercial );
        return true;
    }

    /* Valida y establece el valor del campo Contacto */
    public function setContacto( $s_Contacto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Contacto, "VARCHAR", 120, 0, false ) )
            {
                throw new Exception( "El campo Contacto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setContacto( $s_Contacto );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumento */
    public function setTipoDocumento( $s_TipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumento, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumento( $s_TipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo Documento */
    public function setDocumento( $s_Documento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Documento, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Documento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumento( $s_Documento );
        return true;
    }

    /* Valida y establece el valor del campo CodigoBarras */
    public function setCodigoBarras( $s_CodigoBarras, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoBarras, "VARCHAR", 18, 0, false ) )
            {
                throw new Exception( "El campo CodigoBarras ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoBarras( $s_CodigoBarras );
        return true;
    }

    /* Valida y establece el valor del campo EsCliente */
    public function setEsCliente( $s_EsCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsCliente, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EsCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsCliente( $s_EsCliente );
        return true;
    }

    /* Valida y establece el valor del campo EsProveedor */
    public function setEsProveedor( $s_EsProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsProveedor, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EsProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsProveedor( $s_EsProveedor );
        return true;
    }

    /* Valida y establece el valor del campo EsEmpleado */
    public function setEsEmpleado( $s_EsEmpleado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsEmpleado, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EsEmpleado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsEmpleado( $s_EsEmpleado );
        return true;
    }

    /* Valida y establece el valor del campo EsOtro */
    public function setEsOtro( $s_EsOtro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsOtro, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EsOtro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsOtro( $s_EsOtro );
        return true;
    }

    /* Valida y establece el valor del campo TipoPersona */
    public function setTipoPersona( $s_TipoPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoPersona, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo TipoPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoPersona( $s_TipoPersona );
        return true;
    }

    /* Valida y establece el valor del campo FechaNacimiento */
    public function setFechaNacimiento( $d_FechaNacimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaNacimiento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaNacimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaNacimiento( $d_FechaNacimiento );
        return true;
    }

    /* Valida y establece el valor del campo CiudadNacimiento */
    public function setCiudadNacimiento( $s_CiudadNacimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CiudadNacimiento, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo CiudadNacimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCiudadNacimiento( $s_CiudadNacimiento );
        return true;
    }

    /* Valida y establece el valor del campo Sexo */
    public function setSexo( $s_Sexo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Sexo, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Sexo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSexo( $s_Sexo );
        return true;
    }

    /* Valida y establece el valor del campo Nacionalidad */
    public function setNacionalidad( $s_Nacionalidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Nacionalidad, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Nacionalidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNacionalidad( $s_Nacionalidad );
        return true;
    }

    /* Valida y establece el valor del campo PaisId */
    public function setPaisId( $s_PaisId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PaisId, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo PaisId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPaisId( $s_PaisId );
        return true;
    }

    /* Valida y establece el valor del campo PaisDesc */
    public function setPaisDesc( $s_PaisDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PaisDesc, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo PaisDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPaisDesc( $s_PaisDesc );
        return true;
    }

    /* Valida y establece el valor del campo EstadoCivil */
    public function setEstadoCivil( $s_EstadoCivil, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoCivil, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo EstadoCivil ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoCivil( $s_EstadoCivil );
        return true;
    }

    /* Valida y establece el valor del campo NivelInstruccion */
    public function setNivelInstruccion( $s_NivelInstruccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NivelInstruccion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo NivelInstruccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNivelInstruccion( $s_NivelInstruccion );
        return true;
    }

    /* Valida y establece el valor del campo Direccion */
    public function setDireccion( $s_Direccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Direccion, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo Direccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccion( $s_Direccion );
        return true;
    }

    /* Valida y establece el valor del campo CodigoPostal */
    public function setCodigoPostal( $s_CodigoPostal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoPostal, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo CodigoPostal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoPostal( $s_CodigoPostal );
        return true;
    }

    /* Valida y establece el valor del campo Provincia */
    public function setProvincia( $s_Provincia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Provincia, "VARCHAR", 120, 0, false ) )
            {
                throw new Exception( "El campo Provincia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProvincia( $s_Provincia );
        return true;
    }

    /* Valida y establece el valor del campo Departamento */
    public function setDepartamento( $s_Departamento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Departamento, "VARCHAR", 120, 0, false ) )
            {
                throw new Exception( "El campo Departamento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDepartamento( $s_Departamento );
        return true;
    }

    /* Valida y establece el valor del campo Distrito */
    public function setDistrito( $s_Distrito, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Distrito, "VARCHAR", 120, 0, false ) )
            {
                throw new Exception( "El campo Distrito ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDistrito( $s_Distrito );
        return true;
    }

    /* Valida y establece el valor del campo Telefono */
    public function setTelefono( $s_Telefono, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Telefono, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Telefono ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTelefono( $s_Telefono );
        return true;
    }

    /* Valida y establece el valor del campo Celular */
    public function setCelular( $s_Celular, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Celular, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Celular ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCelular( $s_Celular );
        return true;
    }

    /* Valida y establece el valor del campo Email */
    public function setEmail( $s_Email, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Email, "VARCHAR", 120, 0, false ) )
            {
                throw new Exception( "El campo Email ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmail( $s_Email );
        return true;
    }

    /* Valida y establece el valor del campo DireccionWeb */
    public function setDireccionWeb( $s_DireccionWeb, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DireccionWeb, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo DireccionWeb ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccionWeb( $s_DireccionWeb );
        return true;
    }

    /* Valida y establece el valor del campo Fax */
    public function setFax( $s_Fax, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Fax, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo Fax ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFax( $s_Fax );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoIdentidad */
    public function setDocumentoIdentidad( $s_DocumentoIdentidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoIdentidad, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo DocumentoIdentidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoIdentidad( $s_DocumentoIdentidad );
        return true;
    }

    /* Valida y establece el valor del campo CarnetExtranjeria */
    public function setCarnetExtranjeria( $s_CarnetExtranjeria, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CarnetExtranjeria, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CarnetExtranjeria ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCarnetExtranjeria( $s_CarnetExtranjeria );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoMilitarFA */
    public function setDocumentoMilitarFA( $s_DocumentoMilitarFA, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoMilitarFA, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo DocumentoMilitarFA ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoMilitarFA( $s_DocumentoMilitarFA );
        return true;
    }

    /* Valida y establece el valor del campo TipoBrevete */
    public function setTipoBrevete( $s_TipoBrevete, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoBrevete, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo TipoBrevete ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoBrevete( $s_TipoBrevete );
        return true;
    }

    /* Valida y establece el valor del campo Brevete */
    public function setBrevete( $s_Brevete, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Brevete, "VARCHAR", 18, 0, false ) )
            {
                throw new Exception( "El campo Brevete ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setBrevete( $s_Brevete );
        return true;
    }

    /* Valida y establece el valor del campo Pasaporte */
    public function setPasaporte( $s_Pasaporte, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Pasaporte, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo Pasaporte ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPasaporte( $s_Pasaporte );
        return true;
    }

    /* Valida y establece el valor del campo EsAgenteRetenedor */
    public function setEsAgenteRetenedor( $i_EsAgenteRetenedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_EsAgenteRetenedor, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo EsAgenteRetenedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsAgenteRetenedor( $i_EsAgenteRetenedor );
        return true;
    }

    /* Valida y establece el valor del campo IdRetencion */
    public function setIdRetencion( $i_IdRetencion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRetencion, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdRetencion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRetencion( $i_IdRetencion );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo IdUsuario */
    public function setIdUsuario( $s_IdUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUsuario, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo IdUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUsuario( $s_IdUsuario );
        return true;
    }

    /* Valida y establece el valor del campo ProveedorGuiasFlag */
    public function setProveedorGuiasFlag( $s_ProveedorGuiasFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProveedorGuiasFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ProveedorGuiasFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProveedorGuiasFlag( $s_ProveedorGuiasFlag );
        return true;
    }

    /* Valida y establece el valor del campo EmpleadoVendedorFlag */
    public function setEmpleadoVendedorFlag( $s_EmpleadoVendedorFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpleadoVendedorFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EmpleadoVendedorFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpleadoVendedorFlag( $s_EmpleadoVendedorFlag );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdPersona( $this->getIdPersona(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setApellidoPaterno( $this->getApellidoPaterno(), true );
        $this->setApellidoMaterno( $this->getApellidoMaterno(), true );
        $this->setNombres( $this->getNombres(), true );
        $this->setNombreCompleto( $this->getNombreCompleto(), true );
        $this->setNombreComercial( $this->getNombreComercial(), true );
        $this->setContacto( $this->getContacto(), true );
        $this->setTipoDocumento( $this->getTipoDocumento(), true );
        $this->setDocumento( $this->getDocumento(), true );
        $this->setCodigoBarras( $this->getCodigoBarras(), true );
        $this->setEsCliente( $this->getEsCliente(), true );
        $this->setEsProveedor( $this->getEsProveedor(), true );
        $this->setEsEmpleado( $this->getEsEmpleado(), true );
        $this->setEsOtro( $this->getEsOtro(), true );
        $this->setTipoPersona( $this->getTipoPersona(), true );
        $this->setFechaNacimiento( $this->getFechaNacimiento(), true );
        $this->setCiudadNacimiento( $this->getCiudadNacimiento(), true );
        $this->setSexo( $this->getSexo(), true );
        $this->setNacionalidad( $this->getNacionalidad(), true );
        $this->setPaisId( $this->getPaisId(), true );
        $this->setPaisDesc( $this->getPaisDesc(), true );
        $this->setEstadoCivil( $this->getEstadoCivil(), true );
        $this->setNivelInstruccion( $this->getNivelInstruccion(), true );
        $this->setDireccion( $this->getDireccion(), true );
        $this->setCodigoPostal( $this->getCodigoPostal(), true );
        $this->setProvincia( $this->getProvincia(), true );
        $this->setDepartamento( $this->getDepartamento(), true );
        $this->setDistrito( $this->getDistrito(), true );
        $this->setTelefono( $this->getTelefono(), true );
        $this->setCelular( $this->getCelular(), true );
        $this->setEmail( $this->getEmail(), true );
        $this->setDireccionWeb( $this->getDireccionWeb(), true );
        $this->setFax( $this->getFax(), true );
        $this->setDocumentoIdentidad( $this->getDocumentoIdentidad(), true );
        $this->setCarnetExtranjeria( $this->getCarnetExtranjeria(), true );
        $this->setDocumentoMilitarFA( $this->getDocumentoMilitarFA(), true );
        $this->setTipoBrevete( $this->getTipoBrevete(), true );
        $this->setBrevete( $this->getBrevete(), true );
        $this->setPasaporte( $this->getPasaporte(), true );
        $this->setEsAgenteRetenedor( $this->getEsAgenteRetenedor(), true );
        $this->setIdRetencion( $this->getIdRetencion(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setIdUsuario( $this->getIdUsuario(), true );
        $this->setProveedorGuiasFlag( $this->getProveedorGuiasFlag(), true );
        $this->setEmpleadoVendedorFlag( $this->getEmpleadoVendedorFlag(), true );
        return true;
    }
}
?>