<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ListaPrecioSubFamDet.xml */
/* Generado: 2021-02-20 22:11:20 */

/* Validacion del contenido de los campos campos de la tabla MST_ListaPrecioSubFamDet */
abstract class BaseMST_ListaPrecioSubFamDetBV extends MST_ListaPrecioSubFamDetBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdListaPreciDet */
    public function setIdListaPreciDet( $i_IdListaPreciDet, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdListaPreciDet, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdListaPreciDet ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdListaPreciDet( $i_IdListaPreciDet );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdSubFamilia */
    public function setIdSubFamilia( $s_IdSubFamilia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdSubFamilia, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdSubFamilia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSubFamilia( $s_IdSubFamilia );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoLista */
    public function setIdTipoLista( $i_IdTipoLista, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTipoLista, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTipoLista ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoLista( $i_IdTipoLista );
        return true;
    }

    /* Valida y establece el valor del campo IdRango */
    public function setIdRango( $i_IdRango, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRango, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRango ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRango( $i_IdRango );
        return true;
    }

    /* Valida y establece el valor del campo IdRangoDetalle */
    public function setIdRangoDetalle( $i_IdRangoDetalle, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRangoDetalle, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRangoDetalle ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRangoDetalle( $i_IdRangoDetalle );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoPrecio */
    public function setIdTipoPrecio( $s_IdTipoPrecio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoPrecio, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IdTipoPrecio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoPrecio( $s_IdTipoPrecio );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicio */
    public function setFechaInicio( $d_FechaInicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicio, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicio( $d_FechaInicio );
        return true;
    }

    /* Valida y establece el valor del campo FechaFin */
    public function setFechaFin( $d_FechaFin, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFin, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFin ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFin( $d_FechaFin );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo PrecioCosto */
    public function setPrecioCosto( $f_PrecioCosto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioCosto, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo PrecioCosto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioCosto( $f_PrecioCosto );
        return true;
    }

    /* Valida y establece el valor del campo PrecioCostoIGV */
    public function setPrecioCostoIGV( $f_PrecioCostoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioCostoIGV, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo PrecioCostoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioCostoIGV( $f_PrecioCostoIGV );
        return true;
    }

    /* Valida y establece el valor del campo PorcentajeUtilidad */
    public function setPorcentajeUtilidad( $f_PorcentajeUtilidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PorcentajeUtilidad, "DECIMAL", 8, 4, false ) )
            {
                throw new Exception( "El campo PorcentajeUtilidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPorcentajeUtilidad( $f_PorcentajeUtilidad );
        return true;
    }

    /* Valida y establece el valor del campo PrecioVenta */
    public function setPrecioVenta( $f_PrecioVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioVenta, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo PrecioVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioVenta( $f_PrecioVenta );
        return true;
    }

    /* Valida y establece el valor del campo MontoIGV */
    public function setMontoIGV( $f_MontoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIGV, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo MontoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIGV( $f_MontoIGV );
        return true;
    }

    /* Valida y establece el valor del campo PrecioVentaIGV */
    public function setPrecioVentaIGV( $f_PrecioVentaIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioVentaIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioVentaIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioVentaIGV( $f_PrecioVentaIGV );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuento */
    public function setMontoDescuento( $f_MontoDescuento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuento, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo MontoDescuento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuento( $f_MontoDescuento );
        return true;
    }

    /* Valida y establece el valor del campo PorcentajeDescuento */
    public function setPorcentajeDescuento( $f_PorcentajeDescuento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PorcentajeDescuento, "DECIMAL", 8, 4, false ) )
            {
                throw new Exception( "El campo PorcentajeDescuento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPorcentajeDescuento( $f_PorcentajeDescuento );
        return true;
    }

    /* Valida y establece el valor del campo DescuentoFlag */
    public function setDescuentoFlag( $s_DescuentoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescuentoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DescuentoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescuentoFlag( $s_DescuentoFlag );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdListaPreciDet( $this->getIdListaPreciDet(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdSubFamilia( $this->getIdSubFamilia(), true );
        $this->setIdTipoLista( $this->getIdTipoLista(), true );
        $this->setIdRango( $this->getIdRango(), true );
        $this->setIdRangoDetalle( $this->getIdRangoDetalle(), true );
        $this->setIdTipoPrecio( $this->getIdTipoPrecio(), true );
        $this->setFechaInicio( $this->getFechaInicio(), true );
        $this->setFechaFin( $this->getFechaFin(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setPrecioCosto( $this->getPrecioCosto(), true );
        $this->setPrecioCostoIGV( $this->getPrecioCostoIGV(), true );
        $this->setPorcentajeUtilidad( $this->getPorcentajeUtilidad(), true );
        $this->setPrecioVenta( $this->getPrecioVenta(), true );
        $this->setMontoIGV( $this->getMontoIGV(), true );
        $this->setPrecioVentaIGV( $this->getPrecioVentaIGV(), true );
        $this->setMontoDescuento( $this->getMontoDescuento(), true );
        $this->setPorcentajeDescuento( $this->getPorcentajeDescuento(), true );
        $this->setDescuentoFlag( $this->getDescuentoFlag(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>