<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_DiaSemana.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Validacion del contenido de los campos campos de la tabla MST_DiaSemana */
abstract class BaseMST_DiaSemanaBV extends MST_DiaSemanaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdDiaSem */
    public function setIdDiaSem( $i_IdDiaSem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDiaSem, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDiaSem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDiaSem( $i_IdDiaSem );
        return true;
    }

    /* Valida y establece el valor del campo Prefijo */
    public function setPrefijo( $s_Prefijo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Prefijo, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo Prefijo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrefijo( $s_Prefijo );
        return true;
    }

    /* Valida y establece el valor del campo Nombre */
    public function setNombre( $s_Nombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Nombre, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo Nombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombre( $s_Nombre );
        return true;
    }

    /* Valida y establece el valor del campo DiaNumero */
    public function setDiaNumero( $i_DiaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DiaNumero, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DiaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDiaNumero( $i_DiaNumero );
        return true;
    }

    /* Valida y establece el valor del campo EsFeriadoFlag */
    public function setEsFeriadoFlag( $s_EsFeriadoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsFeriadoFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EsFeriadoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsFeriadoFlag( $s_EsFeriadoFlag );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdDiaSem( $this->getIdDiaSem(), false );
        $this->setPrefijo( $this->getPrefijo(), true );
        $this->setNombre( $this->getNombre(), true );
        $this->setDiaNumero( $this->getDiaNumero(), true );
        $this->setEsFeriadoFlag( $this->getEsFeriadoFlag(), true );
        return true;
    }
}
?>