<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_CuentaBancaria.xml */
/* Generado: 2021-03-04 14:43:30 */

/* Validacion del contenido de los campos campos de la tabla MST_CuentaBancaria */
abstract class BaseMST_CuentaBancariaBV extends MST_CuentaBancariaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCuenta */
    public function setIdCuenta( $i_IdCuenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCuenta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCuenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCuenta( $i_IdCuenta );
        return true;
    }

    /* Valida y establece el valor del campo IdBanco */
    public function setIdBanco( $i_IdBanco, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdBanco, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdBanco ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdBanco( $i_IdBanco );
        return true;
    }

    /* Valida y establece el valor del campo NumeroCuenta */
    public function setNumeroCuenta( $s_NumeroCuenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroCuenta, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo NumeroCuenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroCuenta( $s_NumeroCuenta );
        return true;
    }

    /* Valida y establece el valor del campo NumeroCuentaCCI */
    public function setNumeroCuentaCCI( $s_NumeroCuentaCCI, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroCuentaCCI, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo NumeroCuentaCCI ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroCuentaCCI( $s_NumeroCuentaCCI );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo NombreMoneda */
    public function setNombreMoneda( $s_NombreMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreMoneda, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo NombreMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreMoneda( $s_NombreMoneda );
        return true;
    }

    /* Valida y establece el valor del campo FlagDetraccion */
    public function setFlagDetraccion( $i_FlagDetraccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FlagDetraccion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FlagDetraccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagDetraccion( $i_FlagDetraccion );
        return true;
    }

    /* Valida y establece el valor del campo IdUbigeo */
    public function setIdUbigeo( $s_IdUbigeo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUbigeo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdUbigeo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUbigeo( $s_IdUbigeo );
        return true;
    }

    /* Valida y establece el valor del campo NombreSucursal */
    public function setNombreSucursal( $s_NombreSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreSucursal, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo NombreSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreSucursal( $s_NombreSucursal );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionCuenta */
    public function setDescripcionCuenta( $s_DescripcionCuenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionCuenta, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo DescripcionCuenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionCuenta( $s_DescripcionCuenta );
        return true;
    }

    /* Valida y establece el valor del campo NumeroCuentaCorto */
    public function setNumeroCuentaCorto( $s_NumeroCuentaCorto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroCuentaCorto, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo NumeroCuentaCorto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroCuentaCorto( $s_NumeroCuentaCorto );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo FlagMostrarCuenta */
    public function setFlagMostrarCuenta( $i_FlagMostrarCuenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FlagMostrarCuenta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FlagMostrarCuenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagMostrarCuenta( $i_FlagMostrarCuenta );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCuenta( $this->getIdCuenta(), false );
        $this->setIdBanco( $this->getIdBanco(), true );
        $this->setNumeroCuenta( $this->getNumeroCuenta(), true );
        $this->setNumeroCuentaCCI( $this->getNumeroCuentaCCI(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setNombreMoneda( $this->getNombreMoneda(), true );
        $this->setFlagDetraccion( $this->getFlagDetraccion(), true );
        $this->setIdUbigeo( $this->getIdUbigeo(), true );
        $this->setNombreSucursal( $this->getNombreSucursal(), true );
        $this->setDescripcionCuenta( $this->getDescripcionCuenta(), true );
        $this->setNumeroCuentaCorto( $this->getNumeroCuentaCorto(), true );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setFlagMostrarCuenta( $this->getFlagMostrarCuenta(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>