<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Sucursal.xml */
/* Generado: 2022-01-18 15:31:54 */

/* Validacion del contenido de los campos campos de la tabla GSS_Sucursal */
abstract class BaseGSS_SucursalBV extends GSS_SucursalBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidadProduccion */
    public function setIdUnidadProduccion( $i_IdUnidadProduccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidadProduccion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidadProduccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidadProduccion( $i_IdUnidadProduccion );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Departamento */
    public function setDepartamento( $s_Departamento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Departamento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Departamento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDepartamento( $s_Departamento );
        return true;
    }

    /* Valida y establece el valor del campo Provincia */
    public function setProvincia( $s_Provincia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Provincia, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Provincia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProvincia( $s_Provincia );
        return true;
    }

    /* Valida y establece el valor del campo Distrito */
    public function setDistrito( $s_Distrito, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Distrito, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Distrito ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDistrito( $s_Distrito );
        return true;
    }

    /* Valida y establece el valor del campo Direccion */
    public function setDireccion( $s_Direccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Direccion, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Direccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccion( $s_Direccion );
        return true;
    }

    /* Valida y establece el valor del campo Telefono */
    public function setTelefono( $s_Telefono, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Telefono, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo Telefono ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTelefono( $s_Telefono );
        return true;
    }

    /* Valida y establece el valor del campo Longitud */
    public function setLongitud( $s_Longitud, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Longitud, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Longitud ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLongitud( $s_Longitud );
        return true;
    }

    /* Valida y establece el valor del campo Latitud */
    public function setLatitud( $s_Latitud, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Latitud, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Latitud ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLatitud( $s_Latitud );
        return true;
    }

    /* Valida y establece el valor del campo Ubigeo */
    public function setUbigeo( $s_Ubigeo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Ubigeo, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo Ubigeo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbigeo( $s_Ubigeo );
        return true;
    }

    /* Valida y establece el valor del campo Ip */
    public function setIp( $s_Ip, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Ip, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Ip ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIp( $s_Ip );
        return true;
    }

    /* Valida y establece el valor del campo CuentaContableDefecto */
    public function setCuentaContableDefecto( $s_CuentaContableDefecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaContableDefecto, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaContableDefecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaContableDefecto( $s_CuentaContableDefecto );
        return true;
    }

    /* Valida y establece el valor del campo EstaExoneradoIGV */
    public function setEstaExoneradoIGV( $i_EstaExoneradoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_EstaExoneradoIGV, "TINYINT", 1, 0, false ) )
            {
                throw new Exception( "El campo EstaExoneradoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstaExoneradoIGV( $i_EstaExoneradoIGV );
        return true;
    }

    /* Valida y establece el valor del campo RutaProveedorExt */
    public function setRutaProveedorExt( $s_RutaProveedorExt, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RutaProveedorExt, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo RutaProveedorExt ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRutaProveedorExt( $s_RutaProveedorExt );
        return true;
    }

    /* Valida y establece el valor del campo TokenProveedorExt */
    public function setTokenProveedorExt( $s_TokenProveedorExt, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TokenProveedorExt, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo TokenProveedorExt ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTokenProveedorExt( $s_TokenProveedorExt );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdSucursal( $this->getIdSucursal(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdUnidadProduccion( $this->getIdUnidadProduccion(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setDepartamento( $this->getDepartamento(), true );
        $this->setProvincia( $this->getProvincia(), true );
        $this->setDistrito( $this->getDistrito(), true );
        $this->setDireccion( $this->getDireccion(), true );
        $this->setTelefono( $this->getTelefono(), true );
        $this->setLongitud( $this->getLongitud(), true );
        $this->setLatitud( $this->getLatitud(), true );
        $this->setUbigeo( $this->getUbigeo(), true );
        $this->setIp( $this->getIp(), true );
        $this->setCuentaContableDefecto( $this->getCuentaContableDefecto(), true );
        $this->setEstaExoneradoIGV( $this->getEstaExoneradoIGV(), true );
        $this->setRutaProveedorExt( $this->getRutaProveedorExt(), true );
        $this->setTokenProveedorExt( $this->getTokenProveedorExt(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>