<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_ParametroMast.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Validacion del contenido de los campos campos de la tabla GSS_ParametroMast */
abstract class BaseGSS_ParametroMastBV extends GSS_ParametroMastBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdAplicacionCodigo */
    public function setIdAplicacionCodigo( $s_IdAplicacionCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAplicacionCodigo, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo IdAplicacionCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAplicacionCodigo( $s_IdAplicacionCodigo );
        return true;
    }

    /* Valida y establece el valor del campo IdParametroClave */
    public function setIdParametroClave( $s_IdParametroClave, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdParametroClave, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdParametroClave ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdParametroClave( $s_IdParametroClave );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionParametro */
    public function setDescripcionParametro( $s_DescripcionParametro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionParametro, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo DescripcionParametro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionParametro( $s_DescripcionParametro );
        return true;
    }

    /* Valida y establece el valor del campo Explicacion */
    public function setExplicacion( $s_Explicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Explicacion, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Explicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setExplicacion( $s_Explicacion );
        return true;
    }

    /* Valida y establece el valor del campo TipodeDatoFlag */
    public function setTipodeDatoFlag( $s_TipodeDatoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipodeDatoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TipodeDatoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipodeDatoFlag( $s_TipodeDatoFlag );
        return true;
    }

    /* Valida y establece el valor del campo Texto */
    public function setTexto( $s_Texto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Texto, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo Texto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTexto( $s_Texto );
        return true;
    }

    /* Valida y establece el valor del campo Numero */
    public function setNumero( $f_Numero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Numero, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Numero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumero( $f_Numero );
        return true;
    }

    /* Valida y establece el valor del campo Fecha */
    public function setFecha( $d_Fecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo Fecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha( $d_Fecha );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdAplicacionCodigo( $this->getIdAplicacionCodigo(), false );
        $this->setIdParametroClave( $this->getIdParametroClave(), false );
        $this->setDescripcionParametro( $this->getDescripcionParametro(), true );
        $this->setExplicacion( $this->getExplicacion(), true );
        $this->setTipodeDatoFlag( $this->getTipodeDatoFlag(), true );
        $this->setTexto( $this->getTexto(), true );
        $this->setNumero( $this->getNumero(), true );
        $this->setFecha( $this->getFecha(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>