<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Compania.xml */
/* Generado: 2022-02-16 18:36:47 */

/* Validacion del contenido de los campos campos de la tabla GSS_Compania */
abstract class BaseGSS_CompaniaBV extends GSS_CompaniaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo Codigo */
    public function setCodigo( $s_Codigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Codigo, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Codigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigo( $s_Codigo );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionCorta */
    public function setDescripcionCorta( $s_DescripcionCorta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionCorta, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo DescripcionCorta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionCorta( $s_DescripcionCorta );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionLarga */
    public function setDescripcionLarga( $s_DescripcionLarga, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionLarga, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo DescripcionLarga ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionLarga( $s_DescripcionLarga );
        return true;
    }

    /* Valida y establece el valor del campo Departamento */
    public function setDepartamento( $s_Departamento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Departamento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Departamento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDepartamento( $s_Departamento );
        return true;
    }

    /* Valida y establece el valor del campo Provincia */
    public function setProvincia( $s_Provincia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Provincia, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Provincia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProvincia( $s_Provincia );
        return true;
    }

    /* Valida y establece el valor del campo Distrito */
    public function setDistrito( $s_Distrito, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Distrito, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Distrito ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDistrito( $s_Distrito );
        return true;
    }

    /* Valida y establece el valor del campo DireccionComun */
    public function setDireccionComun( $s_DireccionComun, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DireccionComun, "VARCHAR", 400, 0, false ) )
            {
                throw new Exception( "El campo DireccionComun ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccionComun( $s_DireccionComun );
        return true;
    }

    /* Valida y establece el valor del campo DireccionAdicional */
    public function setDireccionAdicional( $s_DireccionAdicional, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DireccionAdicional, "VARCHAR", 400, 0, false ) )
            {
                throw new Exception( "El campo DireccionAdicional ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccionAdicional( $s_DireccionAdicional );
        return true;
    }

    /* Valida y establece el valor del campo Telefono1 */
    public function setTelefono1( $s_Telefono1, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Telefono1, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Telefono1 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTelefono1( $s_Telefono1 );
        return true;
    }

    /* Valida y establece el valor del campo Telefono2 */
    public function setTelefono2( $s_Telefono2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Telefono2, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Telefono2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTelefono2( $s_Telefono2 );
        return true;
    }

    /* Valida y establece el valor del campo Ruc */
    public function setRuc( $s_Ruc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Ruc, "VARCHAR", 11, 0, false ) )
            {
                throw new Exception( "El campo Ruc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRuc( $s_Ruc );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo Telefono3 */
    public function setTelefono3( $s_Telefono3, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Telefono3, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Telefono3 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTelefono3( $s_Telefono3 );
        return true;
    }

    /* Valida y establece el valor del campo Fax1 */
    public function setFax1( $s_Fax1, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Fax1, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo Fax1 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFax1( $s_Fax1 );
        return true;
    }

    /* Valida y establece el valor del campo Fax2 */
    public function setFax2( $s_Fax2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Fax2, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo Fax2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFax2( $s_Fax2 );
        return true;
    }

    /* Valida y establece el valor del campo AfectoIGVFlag */
    public function setAfectoIGVFlag( $s_AfectoIGVFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AfectoIGVFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AfectoIGVFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAfectoIGVFlag( $s_AfectoIGVFlag );
        return true;
    }

    /* Valida y establece el valor del campo LogoFileDir */
    public function setLogoFileDir( $s_LogoFileDir, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoFileDir, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo LogoFileDir ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoFileDir( $s_LogoFileDir );
        return true;
    }

    /* Valida y establece el valor del campo LogoFile */
    public function setLogoFile( $s_LogoFile, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoFile, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo LogoFile ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoFile( $s_LogoFile );
        return true;
    }

    /* Valida y establece el valor del campo LogoFileAncho */
    public function setLogoFileAncho( $s_LogoFileAncho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoFileAncho, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo LogoFileAncho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoFileAncho( $s_LogoFileAncho );
        return true;
    }

    /* Valida y establece el valor del campo LogoFileAlto */
    public function setLogoFileAlto( $s_LogoFileAlto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoFileAlto, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo LogoFileAlto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoFileAlto( $s_LogoFileAlto );
        return true;
    }

    /* Valida y establece el valor del campo LogoBackFileDir */
    public function setLogoBackFileDir( $s_LogoBackFileDir, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoBackFileDir, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo LogoBackFileDir ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoBackFileDir( $s_LogoBackFileDir );
        return true;
    }

    /* Valida y establece el valor del campo LogoBackFileWeb */
    public function setLogoBackFileWeb( $s_LogoBackFileWeb, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoBackFileWeb, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo LogoBackFileWeb ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoBackFileWeb( $s_LogoBackFileWeb );
        return true;
    }

    /* Valida y establece el valor del campo LogoBackFileAncho */
    public function setLogoBackFileAncho( $s_LogoBackFileAncho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoBackFileAncho, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo LogoBackFileAncho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoBackFileAncho( $s_LogoBackFileAncho );
        return true;
    }

    /* Valida y establece el valor del campo LogoBackFileAlto */
    public function setLogoBackFileAlto( $s_LogoBackFileAlto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoBackFileAlto, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo LogoBackFileAlto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoBackFileAlto( $s_LogoBackFileAlto );
        return true;
    }

    /* Valida y establece el valor del campo RepresentanteLegal */
    public function setRepresentanteLegal( $s_RepresentanteLegal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RepresentanteLegal, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo RepresentanteLegal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRepresentanteLegal( $s_RepresentanteLegal );
        return true;
    }

    /* Valida y establece el valor del campo PaginaWeb */
    public function setPaginaWeb( $s_PaginaWeb, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PaginaWeb, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo PaginaWeb ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPaginaWeb( $s_PaginaWeb );
        return true;
    }

    /* Valida y establece el valor del campo FacturaNotasFormatoPDF */
    public function setFacturaNotasFormatoPDF( $s_FacturaNotasFormatoPDF, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FacturaNotasFormatoPDF, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo FacturaNotasFormatoPDF ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFacturaNotasFormatoPDF( $s_FacturaNotasFormatoPDF );
        return true;
    }

    /* Valida y establece el valor del campo BoletaNotasFormatoPDF */
    public function setBoletaNotasFormatoPDF( $s_BoletaNotasFormatoPDF, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_BoletaNotasFormatoPDF, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo BoletaNotasFormatoPDF ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setBoletaNotasFormatoPDF( $s_BoletaNotasFormatoPDF );
        return true;
    }

    /* Valida y establece el valor del campo EmailEmpresa */
    public function setEmailEmpresa( $s_EmailEmpresa, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmailEmpresa, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo EmailEmpresa ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmailEmpresa( $s_EmailEmpresa );
        return true;
    }

    /* Valida y establece el valor del campo DirParaBuscarComprobante */
    public function setDirParaBuscarComprobante( $s_DirParaBuscarComprobante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DirParaBuscarComprobante, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DirParaBuscarComprobante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDirParaBuscarComprobante( $s_DirParaBuscarComprobante );
        return true;
    }

    /* Valida y establece el valor del campo PorTipoCambio */
    public function setPorTipoCambio( $f_PorTipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PorTipoCambio, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PorTipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPorTipoCambio( $f_PorTipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo EnviarProveedorAutoFlag */
    public function setEnviarProveedorAutoFlag( $s_EnviarProveedorAutoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EnviarProveedorAutoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EnviarProveedorAutoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEnviarProveedorAutoFlag( $s_EnviarProveedorAutoFlag );
        return true;
    }

    /* Valida y establece el valor del campo AfectoRetencionIGVFlag */
    public function setAfectoRetencionIGVFlag( $s_AfectoRetencionIGVFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AfectoRetencionIGVFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AfectoRetencionIGVFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAfectoRetencionIGVFlag( $s_AfectoRetencionIGVFlag );
        return true;
    }

    /* Valida y establece el valor del campo AfectoPercepcionIGVFlag */
    public function setAfectoPercepcionIGVFlag( $s_AfectoPercepcionIGVFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AfectoPercepcionIGVFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AfectoPercepcionIGVFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAfectoPercepcionIGVFlag( $s_AfectoPercepcionIGVFlag );
        return true;
    }

    /* Valida y establece el valor del campo MostrarMargenVenta */
    public function setMostrarMargenVenta( $i_MostrarMargenVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MostrarMargenVenta, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo MostrarMargenVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMostrarMargenVenta( $i_MostrarMargenVenta );
        return true;
    }

    /* Valida y establece el valor del campo CarteraClienteFlag */
    public function setCarteraClienteFlag( $i_CarteraClienteFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CarteraClienteFlag, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo CarteraClienteFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCarteraClienteFlag( $i_CarteraClienteFlag );
        return true;
    }

    /* Valida y establece el valor del campo AprobacionParaImpGuias */
    public function setAprobacionParaImpGuias( $i_AprobacionParaImpGuias, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_AprobacionParaImpGuias, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo AprobacionParaImpGuias ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAprobacionParaImpGuias( $i_AprobacionParaImpGuias );
        return true;
    }

    /* Valida y establece el valor del campo MostrarNumeroLote */
    public function setMostrarNumeroLote( $i_MostrarNumeroLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MostrarNumeroLote, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo MostrarNumeroLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMostrarNumeroLote( $i_MostrarNumeroLote );
        return true;
    }

    /* Valida y establece el valor del campo TrabajarModoAlquiler */
    public function setTrabajarModoAlquiler( $i_TrabajarModoAlquiler, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TrabajarModoAlquiler, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo TrabajarModoAlquiler ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTrabajarModoAlquiler( $i_TrabajarModoAlquiler );
        return true;
    }

    /* Valida y establece el valor del campo OpeCierreCaja */
    public function setOpeCierreCaja( $i_OpeCierreCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OpeCierreCaja, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo OpeCierreCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOpeCierreCaja( $i_OpeCierreCaja );
        return true;
    }

    /* Valida y establece el valor del campo IdClientePorDef */
    public function setIdClientePorDef( $i_IdClientePorDef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdClientePorDef, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdClientePorDef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdClientePorDef( $i_IdClientePorDef );
        return true;
    }

    /* Valida y establece el valor del campo IdUsuarioAdmin */
    public function setIdUsuarioAdmin( $i_IdUsuarioAdmin, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUsuarioAdmin, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdUsuarioAdmin ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUsuarioAdmin( $i_IdUsuarioAdmin );
        return true;
    }

    /* Valida y establece el valor del campo OpeDsctoStockEnGuiaR */
    public function setOpeDsctoStockEnGuiaR( $i_OpeDsctoStockEnGuiaR, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OpeDsctoStockEnGuiaR, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo OpeDsctoStockEnGuiaR ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOpeDsctoStockEnGuiaR( $i_OpeDsctoStockEnGuiaR );
        return true;
    }

    /* Valida y establece el valor del campo LogoBackgroundColor */
    public function setLogoBackgroundColor( $s_LogoBackgroundColor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogoBackgroundColor, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo LogoBackgroundColor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogoBackgroundColor( $s_LogoBackgroundColor );
        return true;
    }

    /* Valida y establece el valor del campo NavbarBackgroundColor */
    public function setNavbarBackgroundColor( $s_NavbarBackgroundColor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NavbarBackgroundColor, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo NavbarBackgroundColor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNavbarBackgroundColor( $s_NavbarBackgroundColor );
        return true;
    }

    /* Valida y establece el valor del campo SidebarBackgroundColor */
    public function setSidebarBackgroundColor( $s_SidebarBackgroundColor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SidebarBackgroundColor, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo SidebarBackgroundColor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSidebarBackgroundColor( $s_SidebarBackgroundColor );
        return true;
    }

    /* Valida y establece el valor del campo UsuSecundarioPruebaUser */
    public function setUsuSecundarioPruebaUser( $s_UsuSecundarioPruebaUser, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuSecundarioPruebaUser, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuSecundarioPruebaUser ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuSecundarioPruebaUser( $s_UsuSecundarioPruebaUser );
        return true;
    }

    /* Valida y establece el valor del campo UsuSecundarioPruebaPass */
    public function setUsuSecundarioPruebaPass( $s_UsuSecundarioPruebaPass, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuSecundarioPruebaPass, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuSecundarioPruebaPass ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuSecundarioPruebaPass( $s_UsuSecundarioPruebaPass );
        return true;
    }

    /* Valida y establece el valor del campo UsuSecundarioProdUser */
    public function setUsuSecundarioProdUser( $s_UsuSecundarioProdUser, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuSecundarioProdUser, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuSecundarioProdUser ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuSecundarioProdUser( $s_UsuSecundarioProdUser );
        return true;
    }

    /* Valida y establece el valor del campo UsuSecundarioProdPass */
    public function setUsuSecundarioProdPass( $s_UsuSecundarioProdPass, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuSecundarioProdPass, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuSecundarioProdPass ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuSecundarioProdPass( $s_UsuSecundarioProdPass );
        return true;
    }

    /* Valida y establece el valor del campo ModoEntorno */
    public function setModoEntorno( $i_ModoEntorno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ModoEntorno, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo ModoEntorno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setModoEntorno( $i_ModoEntorno );
        return true;
    }

    /* Valida y establece el valor del campo Eliminado */
    public function setEliminado( $i_Eliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Eliminado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Eliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEliminado( $i_Eliminado );
        return true;
    }

    /* Valida y establece el valor del campo FechaEliminado */
    public function setFechaEliminado( $d_FechaEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEliminado, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEliminado( $d_FechaEliminado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioEliminado */
    public function setUsuarioEliminado( $s_UsuarioEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioEliminado, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioEliminado( $s_UsuarioEliminado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setCodigo( $this->getCodigo(), true );
        $this->setDescripcionCorta( $this->getDescripcionCorta(), true );
        $this->setDescripcionLarga( $this->getDescripcionLarga(), true );
        $this->setDepartamento( $this->getDepartamento(), true );
        $this->setProvincia( $this->getProvincia(), true );
        $this->setDistrito( $this->getDistrito(), true );
        $this->setDireccionComun( $this->getDireccionComun(), true );
        $this->setDireccionAdicional( $this->getDireccionAdicional(), true );
        $this->setTelefono1( $this->getTelefono1(), true );
        $this->setTelefono2( $this->getTelefono2(), true );
        $this->setRuc( $this->getRuc(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setTelefono3( $this->getTelefono3(), true );
        $this->setFax1( $this->getFax1(), true );
        $this->setFax2( $this->getFax2(), true );
        $this->setAfectoIGVFlag( $this->getAfectoIGVFlag(), true );
        $this->setLogoFileDir( $this->getLogoFileDir(), true );
        $this->setLogoFile( $this->getLogoFile(), true );
        $this->setLogoFileAncho( $this->getLogoFileAncho(), true );
        $this->setLogoFileAlto( $this->getLogoFileAlto(), true );
        $this->setLogoBackFileDir( $this->getLogoBackFileDir(), true );
        $this->setLogoBackFileWeb( $this->getLogoBackFileWeb(), true );
        $this->setLogoBackFileAncho( $this->getLogoBackFileAncho(), true );
        $this->setLogoBackFileAlto( $this->getLogoBackFileAlto(), true );
        $this->setRepresentanteLegal( $this->getRepresentanteLegal(), true );
        $this->setPaginaWeb( $this->getPaginaWeb(), true );
        $this->setFacturaNotasFormatoPDF( $this->getFacturaNotasFormatoPDF(), true );
        $this->setBoletaNotasFormatoPDF( $this->getBoletaNotasFormatoPDF(), true );
        $this->setEmailEmpresa( $this->getEmailEmpresa(), true );
        $this->setDirParaBuscarComprobante( $this->getDirParaBuscarComprobante(), true );
        $this->setPorTipoCambio( $this->getPorTipoCambio(), true );
        $this->setEnviarProveedorAutoFlag( $this->getEnviarProveedorAutoFlag(), true );
        $this->setAfectoRetencionIGVFlag( $this->getAfectoRetencionIGVFlag(), true );
        $this->setAfectoPercepcionIGVFlag( $this->getAfectoPercepcionIGVFlag(), true );
        $this->setMostrarMargenVenta( $this->getMostrarMargenVenta(), true );
        $this->setCarteraClienteFlag( $this->getCarteraClienteFlag(), true );
        $this->setAprobacionParaImpGuias( $this->getAprobacionParaImpGuias(), true );
        $this->setMostrarNumeroLote( $this->getMostrarNumeroLote(), true );
        $this->setTrabajarModoAlquiler( $this->getTrabajarModoAlquiler(), true );
        $this->setOpeCierreCaja( $this->getOpeCierreCaja(), true );
        $this->setIdClientePorDef( $this->getIdClientePorDef(), true );
        $this->setIdUsuarioAdmin( $this->getIdUsuarioAdmin(), true );
        $this->setOpeDsctoStockEnGuiaR( $this->getOpeDsctoStockEnGuiaR(), true );
        $this->setLogoBackgroundColor( $this->getLogoBackgroundColor(), true );
        $this->setNavbarBackgroundColor( $this->getNavbarBackgroundColor(), true );
        $this->setSidebarBackgroundColor( $this->getSidebarBackgroundColor(), true );
        $this->setUsuSecundarioPruebaUser( $this->getUsuSecundarioPruebaUser(), true );
        $this->setUsuSecundarioPruebaPass( $this->getUsuSecundarioPruebaPass(), true );
        $this->setUsuSecundarioProdUser( $this->getUsuSecundarioProdUser(), true );
        $this->setUsuSecundarioProdPass( $this->getUsuSecundarioProdPass(), true );
        $this->setModoEntorno( $this->getModoEntorno(), true );
        $this->setEliminado( $this->getEliminado(), true );
        $this->setFechaEliminado( $this->getFechaEliminado(), true );
        $this->setUsuarioEliminado( $this->getUsuarioEliminado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>