<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_RecibosEstadoLog.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Validacion del contenido de los campos campos de la tabla FCO_RecibosEstadoLog */
abstract class BaseFCO_RecibosEstadoLogBV extends FCO_RecibosEstadoLogBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdEstadoLog */
    public function setIdEstadoLog( $i_IdEstadoLog, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdEstadoLog, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdEstadoLog ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdEstadoLog( $i_IdEstadoLog );
        return true;
    }

    /* Valida y establece el valor del campo IdDocRecibo */
    public function setIdDocRecibo( $i_IdDocRecibo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDocRecibo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDocRecibo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDocRecibo( $i_IdDocRecibo );
        return true;
    }

    /* Valida y establece el valor del campo FlujoEstado */
    public function setFlujoEstado( $s_FlujoEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlujoEstado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo FlujoEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlujoEstado( $s_FlujoEstado );
        return true;
    }

    /* Valida y establece el valor del campo NombreEstado */
    public function setNombreEstado( $s_NombreEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreEstado, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo NombreEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreEstado( $s_NombreEstado );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdEstadoLog( $this->getIdEstadoLog(), false );
        $this->setIdDocRecibo( $this->getIdDocRecibo(), false );
        $this->setFlujoEstado( $this->getFlujoEstado(), true );
        $this->setNombreEstado( $this->getNombreEstado(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>