<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: exp_producto.xml */
/* Generado: 2020-08-18 04:21:32 */

/* Validacion del contenido de los campos campos de la tabla exp_producto */
abstract class BaseExp_productoBV extends Exp_productoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo codigo */
    public function setCodigo( $s_Codigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Codigo, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo codigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigo( $s_Codigo );
        return true;
    }

    /* Valida y establece el valor del campo id_product */
    public function setId_product( $s_Id_product, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Id_product, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo id_product ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setId_product( $s_Id_product );
        return true;
    }

    /* Valida y establece el valor del campo estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo nombre */
    public function setNombre( $s_Nombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Nombre, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo nombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombre( $s_Nombre );
        return true;
    }

    /* Valida y establece el valor del campo minicodigo */
    public function setMinicodigo( $s_Minicodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Minicodigo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo minicodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMinicodigo( $s_Minicodigo );
        return true;
    }

    /* Valida y establece el valor del campo descripcion_largo */
    public function setDescripcion_largo( $u_Descripcion_largo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Descripcion_largo, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo descripcion_largo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion_largo( $u_Descripcion_largo );
        return true;
    }

    /* Valida y establece el valor del campo descripcion_corto */
    public function setDescripcion_corto( $s_Descripcion_corto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion_corto, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo descripcion_corto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion_corto( $s_Descripcion_corto );
        return true;
    }

    /* Valida y establece el valor del campo item_tipo_id */
    public function setItem_tipo_id( $s_Item_tipo_id, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Item_tipo_id, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo item_tipo_id ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItem_tipo_id( $s_Item_tipo_id );
        return true;
    }

    /* Valida y establece el valor del campo item_tipo_desc */
    public function setItem_tipo_desc( $s_Item_tipo_desc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Item_tipo_desc, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo item_tipo_desc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItem_tipo_desc( $s_Item_tipo_desc );
        return true;
    }

    /* Valida y establece el valor del campo linea_prod_id */
    public function setLinea_prod_id( $s_Linea_prod_id, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Linea_prod_id, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo linea_prod_id ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLinea_prod_id( $s_Linea_prod_id );
        return true;
    }

    /* Valida y establece el valor del campo linea_prod_desc */
    public function setLinea_prod_desc( $s_Linea_prod_desc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Linea_prod_desc, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo linea_prod_desc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLinea_prod_desc( $s_Linea_prod_desc );
        return true;
    }

    /* Valida y establece el valor del campo marca_id */
    public function setMarca_id( $s_Marca_id, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Marca_id, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo marca_id ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMarca_id( $s_Marca_id );
        return true;
    }

    /* Valida y establece el valor del campo marca_desc */
    public function setMarca_desc( $s_Marca_desc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Marca_desc, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo marca_desc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMarca_desc( $s_Marca_desc );
        return true;
    }

    /* Valida y establece el valor del campo numero_parte */
    public function setNumero_parte( $s_Numero_parte, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Numero_parte, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo numero_parte ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumero_parte( $s_Numero_parte );
        return true;
    }

    /* Valida y establece el valor del campo tipo_uso_desc */
    public function setTipo_uso_desc( $s_Tipo_uso_desc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Tipo_uso_desc, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo tipo_uso_desc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipo_uso_desc( $s_Tipo_uso_desc );
        return true;
    }

    /* Valida y establece el valor del campo garantia_desc */
    public function setGarantia_desc( $s_Garantia_desc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Garantia_desc, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo garantia_desc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGarantia_desc( $s_Garantia_desc );
        return true;
    }

    /* Valida y establece el valor del campo dim_longitud */
    public function setDim_longitud( $s_Dim_longitud, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Dim_longitud, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo dim_longitud ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDim_longitud( $s_Dim_longitud );
        return true;
    }

    /* Valida y establece el valor del campo dim_alto */
    public function setDim_alto( $s_Dim_alto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Dim_alto, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo dim_alto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDim_alto( $s_Dim_alto );
        return true;
    }

    /* Valida y establece el valor del campo dim_ancho */
    public function setDim_ancho( $s_Dim_ancho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Dim_ancho, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo dim_ancho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDim_ancho( $s_Dim_ancho );
        return true;
    }

    /* Valida y establece el valor del campo dim_peso */
    public function setDim_peso( $s_Dim_peso, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Dim_peso, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo dim_peso ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDim_peso( $s_Dim_peso );
        return true;
    }

    /* Valida y establece el valor del campo dir_imagen_medio */
    public function setDir_imagen_medio( $s_Dir_imagen_medio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Dir_imagen_medio, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo dir_imagen_medio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDir_imagen_medio( $s_Dir_imagen_medio );
        return true;
    }

    /* Valida y establece el valor del campo dir_imagen_accesorio */
    public function setDir_imagen_accesorio( $s_Dir_imagen_accesorio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Dir_imagen_accesorio, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo dir_imagen_accesorio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDir_imagen_accesorio( $s_Dir_imagen_accesorio );
        return true;
    }

    /* Valida y establece el valor del campo dir_imagen_largo */
    public function setDir_imagen_largo( $s_Dir_imagen_largo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Dir_imagen_largo, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo dir_imagen_largo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDir_imagen_largo( $s_Dir_imagen_largo );
        return true;
    }

    /* Valida y establece el valor del campo precio_dol */
    public function setPrecio_dol( $f_Precio_dol, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Precio_dol, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo precio_dol ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecio_dol( $f_Precio_dol );
        return true;
    }

    /* Valida y establece el valor del campo precio_sol */
    public function setPrecio_sol( $f_Precio_sol, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Precio_sol, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo precio_sol ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecio_sol( $f_Precio_sol );
        return true;
    }

    /* Valida y establece el valor del campo stock */
    public function setStock( $i_Stock, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Stock, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo stock ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStock( $i_Stock );
        return true;
    }

    /* Valida y establece el valor del campo caracteristicas */
    public function setCaracteristicas( $u_Caracteristicas, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Caracteristicas, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo caracteristicas ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCaracteristicas( $u_Caracteristicas );
        return true;
    }

    /* Valida y establece el valor del campo fecha_reg */
    public function setFecha_reg( $d_Fecha_reg, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha_reg, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo fecha_reg ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha_reg( $d_Fecha_reg );
        return true;
    }

    /* Valida y establece el valor del campo fecha_upd */
    public function setFecha_upd( $d_Fecha_upd, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha_upd, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo fecha_upd ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha_upd( $d_Fecha_upd );
        return true;
    }

    /* Valida y establece el valor del campo fecha_precio_act */
    public function setFecha_precio_act( $d_Fecha_precio_act, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha_precio_act, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo fecha_precio_act ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha_precio_act( $d_Fecha_precio_act );
        return true;
    }

    /* Valida y establece el valor del campo fecha_caracteristica */
    public function setFecha_caracteristica( $d_Fecha_caracteristica, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha_caracteristica, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo fecha_caracteristica ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha_caracteristica( $d_Fecha_caracteristica );
        return true;
    }

    /* Valida y establece el valor del campo fecha_imagen_act */
    public function setFecha_imagen_act( $d_Fecha_imagen_act, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha_imagen_act, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo fecha_imagen_act ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha_imagen_act( $d_Fecha_imagen_act );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setCodigo( $this->getCodigo(), false );
        $this->setId_product( $this->getId_product(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setNombre( $this->getNombre(), true );
        $this->setMinicodigo( $this->getMinicodigo(), true );
        $this->setDescripcion_largo( $this->getDescripcion_largo(), true );
        $this->setDescripcion_corto( $this->getDescripcion_corto(), true );
        $this->setItem_tipo_id( $this->getItem_tipo_id(), true );
        $this->setItem_tipo_desc( $this->getItem_tipo_desc(), true );
        $this->setLinea_prod_id( $this->getLinea_prod_id(), true );
        $this->setLinea_prod_desc( $this->getLinea_prod_desc(), true );
        $this->setMarca_id( $this->getMarca_id(), true );
        $this->setMarca_desc( $this->getMarca_desc(), true );
        $this->setNumero_parte( $this->getNumero_parte(), true );
        $this->setTipo_uso_desc( $this->getTipo_uso_desc(), true );
        $this->setGarantia_desc( $this->getGarantia_desc(), true );
        $this->setDim_longitud( $this->getDim_longitud(), true );
        $this->setDim_alto( $this->getDim_alto(), true );
        $this->setDim_ancho( $this->getDim_ancho(), true );
        $this->setDim_peso( $this->getDim_peso(), true );
        $this->setDir_imagen_medio( $this->getDir_imagen_medio(), true );
        $this->setDir_imagen_accesorio( $this->getDir_imagen_accesorio(), true );
        $this->setDir_imagen_largo( $this->getDir_imagen_largo(), true );
        $this->setPrecio_dol( $this->getPrecio_dol(), true );
        $this->setPrecio_sol( $this->getPrecio_sol(), true );
        $this->setStock( $this->getStock(), true );
        $this->setCaracteristicas( $this->getCaracteristicas(), true );
        $this->setFecha_reg( $this->getFecha_reg(), true );
        $this->setFecha_upd( $this->getFecha_upd(), true );
        $this->setFecha_precio_act( $this->getFecha_precio_act(), true );
        $this->setFecha_caracteristica( $this->getFecha_caracteristica(), true );
        $this->setFecha_imagen_act( $this->getFecha_imagen_act(), true );
        return true;
    }
}
?>