<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: COM_GastosImportacionDet.xml */
/* Generado: 2021-08-14 18:19:49 */

/* Validacion del contenido de los campos campos de la tabla COM_GastosImportacionDet */
abstract class BaseCOM_GastosImportacionDetBV extends COM_GastosImportacionDetBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdOrdenCompra */
    public function setIdOrdenCompra( $i_IdOrdenCompra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenCompra, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenCompra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenCompra( $i_IdOrdenCompra );
        return true;
    }

    /* Valida y establece el valor del campo GastosImportacionId */
    public function setGastosImportacionId( $i_GastosImportacionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_GastosImportacionId, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo GastosImportacionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGastosImportacionId( $i_GastosImportacionId );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $s_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Secuencia, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $s_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo TipoGastoId */
    public function setTipoGastoId( $s_TipoGastoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoGastoId, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo TipoGastoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoGastoId( $s_TipoGastoId );
        return true;
    }

    /* Valida y establece el valor del campo TipoGastoDesc */
    public function setTipoGastoDesc( $s_TipoGastoDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoGastoDesc, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo TipoGastoDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoGastoDesc( $s_TipoGastoDesc );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 10, 6, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo MontoDolares */
    public function setMontoDolares( $f_MontoDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDolares( $f_MontoDolares );
        return true;
    }

    /* Valida y establece el valor del campo MontoSoles */
    public function setMontoSoles( $f_MontoSoles, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSoles, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSoles ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSoles( $f_MontoSoles );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $s_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FechaCreacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $s_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdOrdenCompra( $this->getIdOrdenCompra(), false );
        $this->setGastosImportacionId( $this->getGastosImportacionId(), false );
        $this->setSecuencia( $this->getSecuencia(), true );
        $this->setTipoGastoId( $this->getTipoGastoId(), true );
        $this->setTipoGastoDesc( $this->getTipoGastoDesc(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setMontoDolares( $this->getMontoDolares(), true );
        $this->setMontoSoles( $this->getMontoSoles(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>