<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_TransferenciaDetalle.xml */
/* Generado: 2020-08-18 04:21:25 */

/* Validacion del contenido de los campos campos de la tabla ALM_TransferenciaDetalle */
abstract class BaseALM_TransferenciaDetalleBV extends ALM_TransferenciaDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTransferencia */
    public function setIdTransferencia( $i_IdTransferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTransferencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTransferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransferencia( $i_IdTransferencia );
        return true;
    }

    /* Valida y establece el valor del campo IdSecuencia */
    public function setIdSecuencia( $i_IdSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSecuencia( $i_IdSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionItem */
    public function setDescripcionItem( $s_DescripcionItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionItem, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DescripcionItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionItem( $s_DescripcionItem );
        return true;
    }

    /* Valida y establece el valor del campo UnidadCodigo */
    public function setUnidadCodigo( $s_UnidadCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadCodigo, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UnidadCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadCodigo( $s_UnidadCodigo );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo CantidadRecepcionada */
    public function setCantidadRecepcionada( $f_CantidadRecepcionada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadRecepcionada, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo CantidadRecepcionada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadRecepcionada( $f_CantidadRecepcionada );
        return true;
    }

    /* Valida y establece el valor del campo CantidadDoble */
    public function setCantidadDoble( $f_CantidadDoble, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadDoble, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo CantidadDoble ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadDoble( $f_CantidadDoble );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioDolares */
    public function setPrecioUnitarioDolares( $f_PrecioUnitarioDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioDolares( $f_PrecioUnitarioDolares );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotalDolares */
    public function setMontoTotalDolares( $f_MontoTotalDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotalDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotalDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotalDolares( $f_MontoTotalDolares );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo Observaciones */
    public function setObservaciones( $s_Observaciones, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Observaciones, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Observaciones ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObservaciones( $s_Observaciones );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTransferencia( $this->getIdTransferencia(), false );
        $this->setIdSecuencia( $this->getIdSecuencia(), false );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdLote( $this->getIdLote(), true );
        $this->setDescripcionItem( $this->getDescripcionItem(), true );
        $this->setUnidadCodigo( $this->getUnidadCodigo(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setCantidadRecepcionada( $this->getCantidadRecepcionada(), true );
        $this->setCantidadDoble( $this->getCantidadDoble(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setPrecioUnitarioDolares( $this->getPrecioUnitarioDolares(), true );
        $this->setMontoTotalDolares( $this->getMontoTotalDolares(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setObservaciones( $this->getObservaciones(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>